/* ====================================================================
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 2000-2001 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "Apache" and "Apache Software Foundation" and
 *     "Apache Jetspeed" must not be used to endorse or promote products
 *    derived from this software without prior written permission. For
 *    written permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache" or
 *    "Apache Jetspeed", nor may "Apache" appear in their name, without
 *    prior written permission of the Apache Software Foundation.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 */

package org.apache.jetspeed.webservices.finance.stockmarket;

import org.apache.turbine.services.Service;
import java.rmi.RemoteException;

/**
    StockQuoteService provides a web service for getting stock quotes.
        
    @author <a href="mailto:taylor@apache.org">David Sean Taylor</a>
    @version $Id: StockQuoteService.java,v 1.2 2001/10/29 08:56:09 taylor Exp $
*/

public interface StockQuoteService extends Service
{
    /** The name of this service */
    public String SERVICE_NAME = "StockQuoteService";


    /**
        Get a single stock quote, given a symbol return the current price.

        @param symbol The stock symbol.
        @return String The current price.
      */
    public String quote( String symbol ) 
        throws RemoteException;

    /**
        Get a single stock quote record, given a symbol return a StockQuote object.

        @param symbol The stock symbol.
        @return StockQuote A full stock quote record.
      */

    public StockQuote fullQuote( String symbol )
            throws RemoteException;

    /**
        Get an array of quote records, given a array of stock symbols.

        @param symbols[] The array of stock symbols.
        @return StockQuote[] An array of full stock quotes for each stock symbol.
      */
    public StockQuote[] fullQuotes( String [] symbol )
            throws RemoteException;

    /**
        Get a comma-delimited list of symbols managed for the given projectName, userName, password.

        @param projectName The project to store the symbols under.
        @param userName The name of the user to look up the stock quotes by.
        @param password The user's password.
        @return String the comma-delimited list of symbols managed for this user.
      */
     public String getSymbols(String projectName, String userName, String password) 
            throws RemoteException;

    /**
        Stores the comma-delimited list of symbols managed for the given projectName, userName, password.

        @param projectName The project to store the symbols under.
        @param userName The name of the user to look up the stock quotes by.
        @param password The user's password.
        @return boolean True if success otherwise false.
      */
     public boolean storeSymbols(String projectName, String userName, String password, String symbols)
            throws RemoteException;

    /**
        Set the name of the web service used by this service to retrieve stock quotes.

        @param service The name of the web service.
      */
    public void setWebService( String service );

    /**
        Get the name of the web service used by this service to retrieve stock quotes.

        @return String The name of the web service.
      */
    public String getWebService();

}
