/* ====================================================================
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 2000-2001 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "Apache" and "Apache Software Foundation" and
 *     "Apache Jetspeed" must not be used to endorse or promote products
 *    derived from this software without prior written permission. For
 *    written permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache" or
 *    "Apache Jetspeed", nor may "Apache" appear in their name, without
 *    prior written permission of the Apache Software Foundation.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 */

package org.apache.jetspeed.util.servlet;

import java.io.IOException;
import java.io.OutputStream;
import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.io.OutputStreamWriter;
import javax.servlet.*;

import org.apache.turbine.util.RunData;
import org.apache.turbine.util.Log;
import org.apache.ecs.ConcreteElement;
import org.apache.ecs.Element;

/**
 * NOTE: The use of Ecs for aggregating portlet content is deprecated!
 *       This utility class will be removed once we don't have the ecs
 *       dependency any more.
 *
 * EcsServletElement encapsulates a servlet/JSP within the context of ECS
 * HTML-generation.
 *
 * This is a workaround to allow invoking servlets from JetSpeed Portlets.
 * The servlet will be invoked when traversal of an ECS tree during writing
 * reaches the EcsServlet element.
 */
public class EcsServletElement extends ConcreteElement
{

    /** RunData object to obtain HttpServletRequest/Response from. */
    private RunData rundata;

    /** URL of servlet to include */
    private String url;

    /**
    * Construct an ECS element from a given rundata object and URL.
    *
    * @param rundata Rundata object that holds the HttpServletRequest/Response
    *                objects to be used for servlet invocation.
    * @param url     The URL of the servlet to invoke.
    */
    public EcsServletElement(RunData rundata, String urlString)
    {
        this.url = urlString;
        this.rundata = rundata;
    }

    /** Builds the content of this element and output it in the
     *  passed OutputStream
     *
     * @param out the OutputStream to use for generating content
     */
    public void output(OutputStream out)
    {
        output(new PrintWriter(out));
    }

    /** Builds the content of this element and output it in the
     *  passed PrintWriter
     *
     * @param out the PrintWriter to use for generating content
     */
    public void output(PrintWriter out) {
        ServletContext ctx = rundata.getServletContext();
        RequestDispatcher dispatcher = ctx.getRequestDispatcher(url);
        try
        {
            // try to flush any data before dispatching request
           // rundata.getResponse().flushBuffer();

            // call the servlet/JSP
            dispatcher.include(
                    rundata.getRequest(),
                    rundata.getResponse() );
        }
        catch (Exception e)
        {
            String message = "EcsServletElement: Could not include the following URL: "
                                + url + " : " + e.getMessage();
            Log.error( message, e );
            out.print(message);
        }
    }
}
