/* ====================================================================
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 2000-2001 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "Apache" and "Apache Software Foundation" and
 *     "Apache Jetspeed" must not be used to endorse or promote products
 *    derived from this software without prior written permission. For
 *    written permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache" or
 *    "Apache Jetspeed", nor may "Apache" appear in their name, without
 *    prior written permission of the Apache Software Foundation.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 */

package org.apache.jetspeed.services.security;

import java.util.Date;

/**
 * A User's statistics for logon attempts. 
 *
 *
 * @author <a href="mailto:david@bluesunrise.com">David Sean Taylor</a>
 * @version $Id: UserLogonStats.java,v 1.1 2002/02/25 04:38:13 taylor Exp $
 */
public class UserLogonStats
{
    private int failures = 0;
    private int total = 0;
    private long firstLogon = 0;
    private final String username;
    private boolean disabled = false;
    private Object sem;

    UserLogonStats(String username)
    {
        this.username = username;
        sem = new Object();
    }

    public int getFailures()
    {
        return failures;
    }

    public int getTotalFailures()
    {
        return total;
    }

    public long getFirstLogon()
    {
        return firstLogon;
    }

    public String getUserName()
    {
        return username;
    }

    public boolean failCheck(int allowed, long secondsAllowed, int max)
    {
        synchronized(sem)
        {
            if (disabled)
                return true;

            failures = failures + 1;
            total = total + 1;
    
            if (total >= max)
            {
                reset();
                disabled = true;
                return true;
            }
        
            long msAllowed = secondsAllowed * 1000;
            long now = new Date().getTime();
           
            if (firstLogon == 0)
                firstLogon = now;
    
            long diff = now - firstLogon;
    
            if (diff > msAllowed)
                reset();
    
            if (failures >= allowed)
            {
                reset();
                disabled = true;
                return true;
            }
            return false;
        }
    }

    public void reset()
    {
        synchronized(sem)
        {
            failures = 0;
            Date now = new Date();
            firstLogon = now.getTime();
            disabled = false;
        }
    }
}
