/* ====================================================================
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 2000-2001 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "Apache" and "Apache Software Foundation" and
 *     "Apache Jetspeed" must not be used to endorse or promote products
 *    derived from this software without prior written permission. For
 *    written permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache" or
 *    "Apache Jetspeed", nor may "Apache" appear in their name, without
 *    prior written permission of the Apache Software Foundation.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 */

package org.apache.jetspeed.services.security;

// Jetspeed imports
import org.apache.jetspeed.portal.Portlet;
import org.apache.jetspeed.om.profile.Entry;
import org.apache.jetspeed.om.registry.RegistryEntry;

import java.io.Serializable;
/**
 * PortalResource
 *
 * @author <a href="paulsp@apache.org">Paul Spencer</a>
 * @version $Id: PortalResource.java,v 1.4 2002/09/26 17:35:59 taylor Exp $
 */
public class PortalResource implements Serializable
{
    public static final int TYPE_PORTLET = 100;
    public static final int TYPE_ENTRY = 200;
    public static final int TYPE_ENTRY_PARAMETER = 201;
    public static final int TYPE_REGISTRY = 300;
    public static final int TYPE_REGISTRY_PARAMETER = 301;

    private int resourceType = 0;

    private Entry entry = null;
    private org.apache.jetspeed.om.profile.Parameter entryParameter = null;
    private Portlet portlet = null;
    private org.apache.jetspeed.om.registry.Parameter registryParameter = null;
    private RegistryEntry registryEntry = null;
    
    /** Holds value of property owner. */
    private String owner;    

    /**
     * Resource is a PSML entry, i.e. a Portlet Instance
     * @param entry PSML Entry, i.e Portlet Instance
     */
    public PortalResource(Entry entry)
    {
        resourceType = TYPE_ENTRY;
        this.entry = entry;
    }

    /**
     * Resource is a parameter associated with a PSML entry, i.e. a Portlet Instance
     * @param entry PSML Entry, i.e Portlet Instance
     * @param parameter Requesting parameter
     */
    public PortalResource(Entry entry, org.apache.jetspeed.om.profile.Parameter parameter)
    {
        resourceType = TYPE_ENTRY_PARAMETER;
        this.entry = entry;
        this.entryParameter = parameter;
    }

    /**
     * Resource is a Portlet, i.e. a Portlet
     * @param portlet Portlet registry entry
     */
    public PortalResource(Portlet portlet)
    {
        resourceType = TYPE_PORTLET;
        this.portlet = portlet;
    }

    /**
     * Resource is a registry entry
     *
     * @param registryEntry of portal resource
     */
    public PortalResource(RegistryEntry registryEntry)
    {
        resourceType = TYPE_REGISTRY;
        this.registryEntry = registryEntry;
    }

    /**
     * Resource is a parameter associated with a registry entry
     * @param registryEntry of portal resource
     * @param parameter Requesting parameter
     */
    public PortalResource(RegistryEntry registryEntry, org.apache.jetspeed.om.registry.Parameter parameter)
    {
        resourceType = TYPE_REGISTRY_PARAMETER;
        this.registryEntry = registryEntry;
        this.registryParameter = parameter;
    }

    /**
     * Getter for property resourceType.
     * @return Value of property resourceType.
     */
    public int getResourceType()
    {
        return resourceType;
    }

    /**
     * Getter for property entry.
     * @return Value of property entry.
     */
    public Entry getEntry()
    {
        return entry;
    }

    /**
     * Getter for property parameter
     * @return Value of property parameter.
     */
    public org.apache.jetspeed.om.profile.Parameter getEntryParameter()
    {
        return entryParameter;
    }

    /**
     * Getter for property portlet.
     * @return Value of property portlet.
     */
    public Portlet getPortlet()
    {
        return portlet;
    }

    /**
     * Getter for property registryEntry.
     * @return Value of property registryEntry.
     */
    public RegistryEntry getRegistryEntry()
    {
        return registryEntry;
    }

    /**
     * Getter for property registryParameter.
     * @return Value of property registryParameter.
     */
    public org.apache.jetspeed.om.registry.Parameter getRegistryParameter()
    {
        return registryParameter;
    }

    /** Getter for property owner.
     * @return Value of property owner.
     */
    public String getOwner()
    {
        return this.owner;
    }
    
    /** Setter for property owner.
     * @param owner New value of property owner.
     */
    public void setOwner(String owner)
    {
        this.owner = owner;
    }
    
}
