/* ====================================================================
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 2000-2001 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "Apache" and "Apache Software Foundation" and
 *     "Apache Jetspeed" must not be used to endorse or promote products
 *    derived from this software without prior written permission. For
 *    written permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache" or
 *    "Apache Jetspeed", nor may "Apache" appear in their name, without
 *    prior written permission of the Apache Software Foundation.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 */


package org.apache.jetspeed.services.security;

import java.util.Iterator;

import org.apache.turbine.services.Service;
import org.apache.turbine.services.TurbineServices;

import org.apache.jetspeed.om.security.JetspeedUser;
import org.apache.jetspeed.om.security.Role;
import org.apache.jetspeed.om.security.Permission;
import org.apache.jetspeed.services.security.JetspeedSecurityException;

/**
 * The Security Cache Service caches roles and permissions (ACLs)
 *
 * @author <a href="mailto:taylor@apache.org">David Sean Taylor</a>
 * @version $Id: JetspeedSecurityCache.java,v 1.4 2002/07/16 17:27:05 taylor Exp $
 */


public abstract class JetspeedSecurityCache
{
   /** The name of this service */
   public String SERVICE_NAME = "SecurityCache";


   /*
    * Utility method for accessing the service
    * implementation
    *
    * @return a SecurityCacheService implementation instance
    */
   protected static SecurityCacheService getService()
   {
       return (SecurityCacheService)TurbineServices
       .getInstance().getService(SecurityCacheService.SERVICE_NAME);
   }

   /*
    * 
    * The class that is created by the default JetspeedUserFactory is configured
    * in the JetspeedSecurity properties:
    *
    *    services.JetspeedSecurity.user.class=
    *        org.apache.jetspeed.om.security.BaseJetspeedUser
    *
    * @param JetspeedUser the user to cache all role and permission information for.
    */
    public static void load(String username)
        throws JetspeedSecurityException
    {
        getService().load(username);
    }

    public static void unload(String username)
    {
        getService().unload(username);
    }

    public static void loadRolePermissions()
    {
        getService().loadRolePermissions();
    }

    public static Role getRole(String username, String roleName)
    {
        return getService().getRole(username, roleName);
    }
    
    public static void addRole(String username, Role role)
    {
        getService().addRole(username, role);
    }

    public static boolean hasRole(String username, String roleName)
    {
        return getService().hasRole(username, roleName);
    }

    public static void removeRole(String username, String roleName)
    {
        getService().removeRole(username, roleName);
    }

    public static Iterator getRoles(String username)
    {
        return getService().getRoles(username);
    }

    public static CachedAcl getAcl(String username)
    {
        return getService().getAcl(username);
    }

    public static void removeAllRoles(String rolename)
    {
        getService().removeAllRoles(rolename);
    }

    public static void removeAllPermissions(String permissionName)
    {
        getService().removeAllPermissions(permissionName);
    }

    public static Permission getPermission(String roleName, String permissionName)
    {
        return getService().getPermission(roleName, permissionName);
    }
    
    public static void addPermission(String roleName, Permission permission)
    {
        getService().addPermission(roleName, permission);
    }

    public static boolean hasPermission(String roleName, String permissionName)
    {
        return getService().hasPermission(roleName, permissionName);
    }

    public static void removePermission(String roleName, String permissionName)
    {
        getService().removePermission(roleName, permissionName);
    }

    public static Iterator getPermissions(String roleName)
    {
        return getService().getPermissions(roleName);
    }

}



