/* ====================================================================
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 2000-2001 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "Apache" and "Apache Software Foundation" and
 *     "Apache Jetspeed" must not be used to endorse or promote products
 *    derived from this software without prior written permission. For
 *    written permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache" or
 *    "Apache Jetspeed", nor may "Apache" appear in their name, without
 *    prior written permission of the Apache Software Foundation.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 */

package org.apache.jetspeed.services.registry;

import java.util.Collection;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.Vector;

// Junit imports
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.framework.TestCase;

import org.apache.jetspeed.om.registry.*;
import org.apache.jetspeed.om.registry.base.*;

import ojb.broker.PersistenceBroker;
import ojb.broker.PersistenceBrokerFactory;
import ojb.broker.query.Query;
import ojb.broker.query.QueryByCriteria;
import ojb.broker.query.Criteria;

import org.apache.turbine.util.TurbineConfig;
import org.apache.turbine.util.StringUtils;

import org.apache.jetspeed.services.JetspeedDatabase;

/**
 * TestRegistryPersistence
 *
 * @author <a href="taylor@apache.org">David Sean Taylor</a>
 * @version $Id: TestRegistryPersistence.java,v 1.3 2002/10/15 17:35:32 taylor Exp $
 */

public class TestRegistryPersistence extends TestCase {    

    /**
     * Defines the testcase name for JUnit.
     *
     * @param name the testcase's name.
     */
    public TestRegistryPersistence( String name ) {
        super( name );
    }
    
    /**
     * Start the tests.
     *
     * @param args the arguments. Not used
     */
    public static void main(String args[]) {
        junit.awtui.TestRunner.main( new String[] { TestRegistryPersistence.class.getName() } );
    }
 
    public void setup() {
        System.out.println("Setup: Testing ObjectBridge");
     }
    /**
     * Creates the test suite.
     *
     * @return a test suite (<code>TestSuite</code>) that includes all methods
     *         starting with "test"
     */
    public static Test suite() {
        // All methods starting with "test" will be executed in the test suite.
        return new TestSuite( TestRegistryPersistence.class );
    }

    /**
     * 
     *
     * @throws Exception
     */

    public void testInsertUpdateDelete() throws Exception 
    {
        PersistenceBroker pm = null;
        try
        {
            pm = (PersistenceBroker) JetspeedDatabase.getPersistenceManager();

            MediaTypeTest(pm);
            SkinTest(pm);  
        }
        catch (Throwable t)
        {
            t.printStackTrace();
        }
    }

    void MediaTypeTest(PersistenceBroker pm) throws Exception
    {
        // test insert
        BaseMediaTypeEntry newEntry = new BaseMediaTypeEntry(0, "XHTML9", 0, "text.xhtml.9", 
                                                             "Some Title", "Some Description", "Some Image", "SU");

        pm.beginTransaction();
        pm.store(newEntry);
        pm.commitTransaction();

        // test update
        Criteria criteria = new Criteria();
        criteria.addEqualTo("name", "XHTML9");
        Query query = new QueryByCriteria(BaseMediaTypeEntry.class, criteria);
        BaseMediaTypeEntry entry  = (BaseMediaTypeEntry)pm.getObjectByQuery(query);
        assertTrue(entry.getName().equals("XHTML9"));           
        System.out.println("id = " + entry.getId());
        assertTrue(entry.getHidden() == false);           
        assertTrue(entry.getMimeType().equals("text.xhtml.9"));           
        assertTrue(entry.getMetaInfo().getTitle().equals("Some Title"));           
        assertTrue(entry.getDescription().equals("Some Description"));           
        assertTrue(entry.getMetaInfo().getImage().equals("Some Image"));           
        assertTrue(entry.getSecurity().getRole().equals("SU"));                     

        entry.setHidden(true);
        entry.setMimeType("text.xhtml.9.1");
        entry.getMetaInfo().setTitle("New Title");
        entry.setDescription("New Description");
        entry.getSecurity().setRole("Dumb");

        pm.beginTransaction();
        pm.store(entry);
        pm.commitTransaction();

        // delete
        pm.beginTransaction();
        BaseMediaTypeEntry entry2  = (BaseMediaTypeEntry)pm.getObjectByQuery(query);
        assertTrue(entry2.getHidden() == true);           
        assertTrue(entry2.getMimeType().equals("text.xhtml.9.1"));           
        assertTrue(entry2.getMetaInfo().getTitle().equals("New Title"));           
        assertTrue(entry2.getMetaInfo().getDescription().equals("New Description"));           
        assertTrue(entry2.getSecurity().getRole().equals("Dumb"));                     

        pm.delete(entry2);
        pm.commitTransaction();

    }

    void SkinTest(PersistenceBroker pm) throws Exception
    {
        // DST: left off here
    }

   /*
      Configuration object to run Turbine outside a servlet container
      ( uses turbine.properties )
    */
    private static TurbineConfig config = null;
    
    /*    
      Sets up TurbineConfig using the system property:
      <pre>turbine.properties</pre>
    */
    static
    {
        try
        {
           config = new TurbineConfig( "../webapp", "/WEB-INF/conf/TurbineResources.properties");
           config.init();
        }
        catch (Exception e)
        {
            //fail(StringUtils.stackTrace(e));
            System.out.println(StringUtils.stackTrace(e));
        }
    }
}