/* ====================================================================
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 2000-2001 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "Apache" and "Apache Software Foundation" and
 *     "Apache Jetspeed" must not be used to endorse or promote products
 *    derived from this software without prior written permission. For
 *    written permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache" or
 *    "Apache Jetspeed", nor may "Apache" appear in their name, without
 *    prior written permission of the Apache Software Foundation.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 */

package org.apache.jetspeed.services.customlocalization;

/**
 * This service handles the generation of unique identifiers
 *
 * @author <a href="mailto:desmax74@yahoo.it">Dess Massimiliano</a>
 * @version $Id: JetspeedLocalizationService.java,v 1.3 2002/11/16 17:30:31 paulsp Exp $
 */

// Java imports
import java.util.Hashtable;
import java.util.Locale;
import java.util.ResourceBundle;

// Turbine imports
import org.apache.turbine.services.localization.TurbineLocalizationService;
import org.apache.turbine.services.InitializationException;
import org.apache.turbine.services.resources.TurbineResources;
import org.apache.turbine.util.RunData;

// Jetspeed imports
import org.apache.jetspeed.om.security.JetspeedUser;


public class JetspeedLocalizationService extends TurbineLocalizationService implements CustomLocalizationService
{
    public JetspeedLocalizationService()
    {
        super();
    }

    public void init() throws InitializationException
    {
        super.init();
    }

    protected void initBundleNames(String ignored[])
    {
      bundleNames = TurbineResources.getStringArray("locale.default.bundles");
      String name = TurbineResources.getString("locale.default.bundle");
      if (name != null && name.length() > 0)
      {
          if (bundleNames == null || bundleNames.length <= 0)
          {
              bundleNames = (new String[] {name});
          }
          else
          {
              String array[] = new String[bundleNames.length + 1];
              array[0] = name;
              System.arraycopy(bundleNames, 0, array, 1, bundleNames.length);
              bundleNames = array;
          }
      }
      if (bundleNames == null)
      {
          bundleNames = new String[0];
      }
    }

    public String getDefaultBundleName()
    {
      return bundleNames.length > 0 ? bundleNames[0] : "";
    }

    public ResourceBundle getBundle()
    {
        return super.getBundle();
    }

    public ResourceBundle getBundle(String bundleName)
    {
        return super.getBundle(bundleName);
    }

    public ResourceBundle getBundle(String bundleName, String languageHeader)
    {
      return super.getBundle(bundleName, languageHeader);
    }

    public ResourceBundle getBundle(RunData data)
    {
      return super.getBundle(data);
    }

    public ResourceBundle getBundle(String bundleName, RunData data)
    {
      return super.getBundle(bundleName, data);
    }

    public ResourceBundle getBundle(String bundleName, Locale locale)
    {
     return super.getBundle(bundleName, locale);
    }

    public void setBundle(String defaultBundle)
    {
      super.setBundle(defaultBundle);
    }


    public final Locale getLocale(RunData data)
    {
       JetspeedUser user = (JetspeedUser) data.getUser();
       if (user == null)
       {
         return getLocale(data.getRequest().getHeader(CustomLocalizationService.ACCEPT_LANGUAGE));
       }
       else
       {
         String lang = "null";

         try
         {
           if (user.getPerm("language") == null)
           {
             return getLocale(data.getRequest().getHeader(CustomLocalizationService.ACCEPT_LANGUAGE));
           }
           else
           {
             lang = user.getPerm("language").toString();
             Locale locale = new Locale(lang, "");
             return locale;
           }
         }
         catch (Exception use)
         {
           return getLocale(data.getRequest().getHeader(CustomLocalizationService.ACCEPT_LANGUAGE));
         }
       }
    }


    public Locale getLocale(String header)
    {
        return super.getLocale(header);
    }

    public String getString(String bundleName, Locale locale, String key)
    {
      return super.getString(bundleName, locale, key);
    }

    private Hashtable bundles;
    private String bundleNames[];
    private Locale defaultLocale;
    private String defaultLanguage;
    private String defaultCountry;
}
