/* ====================================================================
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 2000-2001 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "Apache" and "Apache Software Foundation" and
 *     "Apache Jetspeed" must not be used to endorse or promote products
 *    derived from this software without prior written permission. For
 *    written permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache" or
 *    "Apache Jetspeed", nor may "Apache" appear in their name, without
 *    prior written permission of the Apache Software Foundation.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 */

package org.apache.jetspeed.services;

import org.apache.jetspeed.services.template.TemplateLocatorService;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.util.RunData;

import java.util.Locale;

/**
 * <P>This is a commodity static accessor class around the 
 * <code>TemplateLocatorService</code> interface</P>
 * 
 * @see org.apache.jetspeed.services.template.TemplateLocatorService
 *
 * @author <a href="mailto:taylor@apache.org">David Sean Taylor</a>
 * @author <a href="mailto:paulsp@apache.org">Paul Spencer</a>
 * @author <a href="mailto:kimptoc_mail@yahoo.com">Chris Kimpton</a>
 * @version $Id: TemplateLocator.java,v 1.4 2002/10/24 16:17:21 morciuch Exp $
 */
public class TemplateLocator
{
    /** 
     * Commodity method for getting a reference to the service
     * singleton
     */
    private static TemplateLocatorService getService()
    {
        return (TemplateLocatorService)TurbineServices
                .getInstance()
                .getService(TemplateLocatorService.SERVICE_NAME);
    }

    /**
     * @see TemplateLocatorService#locateScreenTemplate
     */
    public static String locateScreenTemplate(RunData data, String template)
    {
        return getService().locateScreenTemplate(data, template);
    }

    /**
     * @see TemplateLocatorService#locateLayoutTemplate
     */
    public static String locateLayoutTemplate(RunData data, String template)
    {
        return getService().locateLayoutTemplate(data, template);
    }

    /**
     * @see TemplateLocatorService#locatePortletTemplate
     */
    public static String locatePortletTemplate(RunData data, String template)
    {
        return getService().locatePortletTemplate(data, template);
    }

    /**
     * @see TemplateLocatorService#locateControlTemplate
     */
    public static String locateControlTemplate(RunData data, String template)
    {
        return getService().locateControlTemplate(data, template);
    }

    /**
     * @see TemplateLocatorService#locateControllerTemplate
     */
    public static String locateControllerTemplate(RunData data, String template)
    {
        return getService().locateControllerTemplate(data, template);
    }

    /**
     * @see TemplateLocatorService#locateNavigationTemplate
     */
    public static String locateNavigationTemplate(RunData data, String template)
    {
        return getService().locateNavigationTemplate(data, template);
    }

    /**
     * @see TemplateLocatorService#locateEmailTemplate
     */
    public static String locateEmailTemplate(RunData data, String template)
    {
        return getService().locateEmailTemplate(data, template);
    }


    /**
     * @see TemplateLocatorService#locateEmailTemplate
     */
    public static String locateEmailTemplate(RunData data, String template, Locale locale)
    {
        return getService().locateEmailTemplate(data, template, locale);
    }

    /**
     * @see TemplateLocatorService#locateParameterTemplate
     */
    public static String locateParameterTemplate(RunData data, String template)
    {
        return getService().locateParameterTemplate(data, template);
    }

}
