/* ====================================================================
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 2000-2001 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "Apache" and "Apache Software Foundation" and
 *     "Apache Jetspeed" must not be used to endorse or promote products
 *    derived from this software without prior written permission. For
 *    written permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache" or
 *    "Apache Jetspeed", nor may "Apache" appear in their name, without
 *    prior written permission of the Apache Software Foundation.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 */

package org.apache.jetspeed.portal.security.portlets;

//jetspeed
import org.apache.jetspeed.portal.Portlet;
import org.apache.jetspeed.portal.PortletState;

import org.apache.jetspeed.services.JetspeedSecurity;

//turbine
import org.apache.turbine.util.RunData;
//import org.apache.turbine.util.TurbineRuntimeException;



/**
<p>
This object is used to wrap a Portlet, ensuring that access control rules are enforced.
</p>

@author <A HREF="mailto:sgala@apache.org">Santiago Gala</A>
@author <A HREF="mailto:morciuch@apache.org">Mark Orciuch</A>
@version $Id: StatefulPortletWrapper.java,v 1.3 2002/09/10 15:12:08 morciuch Exp $
*/
public class StatefulPortletWrapper extends PortletWrapper implements PortletState
{

    /*
     * The portletstate of our portlet
     */
    private PortletState wrappedState = null;

    public StatefulPortletWrapper( Portlet inner )
    {
        super( inner );
        if( inner instanceof PortletState )
        {
            wrappedState = (PortletState) inner;
        }
        else
        {
            //Report error or throw exception
        }
    }

    // PortletState Interface implementation
    
    /**
     * Implements the default close behavior: any authenticated user may
     * remove a portlet from his page
     *
     * @param rundata the RunData object for the current request
     */
    public final boolean allowClose( RunData rundata )
    {
        return checkPermission(rundata, 
                               JetspeedSecurity.PERMISSION_CLOSE );
    }

    /**
     * Returns true if this portlet is currently closed
     */
    public final boolean isClosed(RunData rundata)
    {
        if( checkPermission(rundata, 
                            JetspeedSecurity.PERMISSION_VIEW ) )
        {
            return wrappedState.isClosed( rundata );
        }
        else
        {
            //FIXME: for the moment we will allow this call to succeed...
            //throw new TurbineRuntimeException( "Security check failed" );
            return wrappedState.isClosed( rundata );
        }
    }

    /**
     * Toggles the portlet state between closed and normal
     *
     * @param minimized the new portlet state
     * @param data the RunData for this request
     */
    public final void setClosed(boolean close, RunData rundata)
    {
        if( allowClose( rundata ) )
        {
            wrappedState.setClosed( close, rundata );
        }
    }

    /**
     * Implements the default info behavior: any authenticated user may
     * get information on a portlet
     *
     * @param rundata the RunData object for the current request
     */
    public final boolean allowInfo( RunData rundata )
    {
        return checkPermission(rundata, 
                               JetspeedSecurity.PERMISSION_INFO );
    }

    /**
     * Implements the default customize behavior: any authenticated user may
     * customize a portlet
     *
     * @param rundata the RunData object for the current request
     */
    public final boolean allowCustomize( RunData rundata )
    {
        return checkPermission(rundata, 
                               JetspeedSecurity.PERMISSION_CUSTOMIZE );
    }

    /**
     * Implements the default maximize behavior: any authenticated user may
     * maximize a portlet
     *
     * @param rundata the RunData object for the current request
     */
    public boolean allowMaximize( RunData rundata )
    {
        return checkPermission(rundata, 
                               JetspeedSecurity.PERMISSION_MAXIMIZE );
    }

    /**
     * Implements the default info behavior: any authenticated user may
     * minimize a portlet
     *
     * @param rundata the RunData object for the current request
     */
    public boolean allowMinimize( RunData rundata )
    {
        return checkPermission(rundata, 
                               JetspeedSecurity.PERMISSION_MINIMIZE );
    }

    /**
     * Returns true if this portlet is currently minimized
     */
    public boolean isMinimized(RunData rundata)
    {
        if( checkPermission(rundata, 
                            JetspeedSecurity.PERMISSION_VIEW ) )
        {
            return wrappedState.isMinimized( rundata );
        }
        else
        {
            //FIXME: for the moment we will allow this call to succeed...
            //throw new TurbineRuntimeException( "Security check failed" );
            return wrappedState.isMinimized( rundata );
        }
    }

    /**
    Change the portlet visibility state ( minimized <-> normal )

    @param minimize True if the portlet change to minimized
    @param rundata A RunData object
    */
    public void setMinimized( boolean minimize, RunData rundata )
    {
        if( allowMinimize( rundata ) )
        {
            wrappedState.setMinimized(minimize, rundata );
        }
    }
    
    /**
     * Implements the default info behavior: any authenticated user may
     * view portlet in print friendly format
     *
     * @param rundata the RunData object for the current request
     */
    public boolean allowPrintFriendly( RunData rundata )
    {
        return checkPermission(rundata, 
                               JetspeedSecurity.PERMISSION_PRINT_FRIENDLY );
    }

}
