/* ====================================================================
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 2000-2001 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "Apache" and "Apache Software Foundation" and
 *     "Apache Jetspeed" must not be used to endorse or promote products
 *    derived from this software without prior written permission. For
 *    written permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache" or
 *    "Apache Jetspeed", nor may "Apache" appear in their name, without
 *    prior written permission of the Apache Software Foundation.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 */

package org.apache.jetspeed.portal.portlets;

//standard java stuff
import java.io.*;
import java.util.*;

//Element Construction Set
import org.apache.jetspeed.util.JetspeedClearElement;
import org.apache.ecs.ConcreteElement;

//standard Jetspeed stuff
import org.apache.jetspeed.util.*;
import org.apache.jetspeed.cache.disk.*;
import org.apache.jetspeed.portal.*;
import org.apache.jetspeed.capability.CapabilityMap;
import org.apache.jetspeed.services.rundata.JetspeedRunData;

//turbine
import org.apache.turbine.util.*;

//SAX
import org.xml.sax.*;

/**
Simple portlet which does a basic XSLT transform with the stylesheet parameter
and the given portlet URL.

@author <A HREF="mailto:raphael@apache.org">Raphal Luta</A>
@version $Id: XSLPortlet.java,v 1.8 2002/11/07 20:22:45 raphael Exp $
*/
public class XSLPortlet extends AbstractPortlet {

    /**
    The stylesheet parameter
    */
    public static final String STYLESHEET = "stylesheet";

    public final static String ERROR_NOT_VALID = "This does not appear to be an RSS document";
    public final static String INVALID_TYPE = "Unable to display for this browser";

    private Hashtable stylesheets = null;

    /**
    This method loads the init parameters
    */
    public void init() throws PortletException {

        stylesheets = new Hashtable();
        Iterator en = this.getPortletConfig().getInitParameterNames();
        while (en.hasNext()) {
            String name = (String)en.next();
            String base = MimeType.HTML.toString();
            if (name.startsWith(STYLESHEET)) {
                int idx=-1;
                if ((idx=name.indexOf("."))>-1) {
                    base= name.substring(idx+1,name.length());
                }
                stylesheets.put(base,this.getPortletConfig().getInitParameter(name));
            }
        }
    }


    /**
    This methods outputs the content of the portlet for a given
    request.

    @param data the RunData object for the request
    @return the content to be displayed to the user-agent
    */
    public ConcreteElement getContent( RunData data ) {
        CapabilityMap map = ((JetspeedRunData)data).getCapability();
        String type = map.getPreferredType().toString();
        ConcreteElement content = new JetspeedClearElement(INVALID_TYPE);
        String stylesheet = (String)stylesheets.get(type);

        if (stylesheet != null) {
            content = getContent( data, map );
            if ( content == null ) {
                try {
                    content = new JetspeedClearElement(
                        SimpleTransform.transform( getPortletConfig().getURL(),
                                                   stylesheet,
                                                   getPortletConfig().getInitParameters() ) );
                    setContent( content, map );
                } catch ( SAXException e ) {
                    Log.error( e );
                    content = new JetspeedClearElement(e.getMessage());
                }
            }
        }

        return content;
    }

    /**
    This portlet supports has many types as those
    it has stylesheets defined for in its parameters

    @see Portlet#supportsType
    @param mimeType the MIME type queried
    @return true if the portlet knows how to display
    content for mimeType
    */
    public boolean supportsType( MimeType mimeType ) {

        Enumeration en = stylesheets.keys();
        while(en.hasMoreElements()) {
            String type = (String)en.nextElement();
            if (type.equals(mimeType.toString())) return true;
        }

        return false;
    }

}
