/* ====================================================================
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 2000-2001 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "Apache" and "Apache Software Foundation" and
 *     "Apache Jetspeed" must not be used to endorse or promote products
 *    derived from this software without prior written permission. For
 *    written permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache" or
 *    "Apache Jetspeed", nor may "Apache" appear in their name, without
 *    prior written permission of the Apache Software Foundation.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 */

package org.apache.jetspeed.portal.portlets;

import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import org.apache.ecs.html.Comment;
import org.apache.ecs.ConcreteElement;
import org.apache.ecs.StringElement;
import org.apache.ecs.ElementContainer;
import org.apache.jetspeed.cache.disk.JetspeedDiskCache;
import org.apache.jetspeed.util.SAXPIFilter;
import org.apache.turbine.util.RunData;
import org.apache.turbine.util.Log;

/**
Portlet to output an XML well-formed document without any rendering.
Strips all PIs and XML declaration before outputting content to allow
for inclusion in a wider XML document.

@author <A HREF="mailto:raphael@apache.org">Raphal Luta</A>
@version $Id: XMLPortlet.java,v 1.19 2001/03/07 06:47:17 taylor Exp $
*/
public class XMLPortlet extends AbstractPortlet {


    /**
    Return the PI-stripped XML document wrapped in an ECS ElementContainer
    */
    public ConcreteElement getContent( RunData rundata ) {

        String myContent = null;

        ElementContainer content = new ElementContainer();
        
        // Strip all PIs and XML declaration from the input XML content URL
        try {

            ByteArrayOutputStream bos= new ByteArrayOutputStream();

            String url = JetspeedDiskCache.getInstance().getEntry( getPortletConfig().getURL() ).getURL();

            new SAXPIFilter(new PrintWriter(bos),true).print( url );
            myContent = bos.toString();

        } catch (Exception e) {

            
            Log.error( "Could not parse the following URL:  " + this.getPortletConfig().getURL(), e );
            return content;
        }

        // If parsing is OK, wraps content in ECS element
        if (myContent!=null) {
            content = new ElementContainer();

            content.addElement( new Comment( "BEGIN PORTLET" ) );
            content.addElement( new StringElement( myContent ) );
            content.addElement( new Comment( "END PORTLET" ) );
        }

        return content;
    }

    /**
    Return the PI-stripped XML document wrapped in an ECS ElementContainer.
    Currently same as getContent()
    */
    public ConcreteElement getContent(Object params, RunData rundata) {
        return getContent( rundata );
    }


}
