/* ====================================================================
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 2000-2001 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "Apache" and "Apache Software Foundation" and
 *     "Apache Jetspeed" must not be used to endorse or promote products
 *    derived from this software without prior written permission. For
 *    written permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache" or
 *    "Apache Jetspeed", nor may "Apache" appear in their name, without
 *    prior written permission of the Apache Software Foundation.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 */

package org.apache.jetspeed.portal.portlets;

// Turbine util
import org.apache.turbine.util.RunData;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.services.jsp.JspService;
import org.apache.turbine.util.Log;
import org.apache.turbine.modules.ActionLoader;

// Jetspeed portal
import org.apache.jetspeed.portal.Portlet;
import org.apache.jetspeed.portal.portlets.AbstractInstancePortlet;
import org.apache.jetspeed.portal.PortletException;
import org.apache.jetspeed.portal.PortletConfig;
import org.apache.jetspeed.services.template.TemplateLocatorService;

// Ecs 
import org.apache.ecs.ConcreteElement;
import org.apache.ecs.ElementContainer;
import org.apache.ecs.StringElement;


/**
 * A JSP portlet example.
 * 
 * @author <a href="mailto:taylor@apache.org">David Sean Taylor</a>
 * @author <a href="mailto:sgala@apache.org">Santiago Gala</a>
 */
public class JspPortlet extends AbstractInstancePortlet

{

    /**
    By default the data is non cacheable
    */
    public void init() throws PortletException
    {
        setCacheable( false );
    }

    public ConcreteElement getContent( RunData rundata )
    {

        String template = "";

        try {

            // 
            // gets the jsp page from the xreg configuration
            // NOTE: wouldn't it be better to get the param from the PSML?
            //
            template = getPortletConfig().getInitParameter("template");

            //we use the template locator service to translate the template
            TemplateLocatorService lserv = (TemplateLocatorService)TurbineServices.getInstance()
                .getService(TemplateLocatorService.SERVICE_NAME);
            String locatedTemplate = lserv.locatePortletTemplate( rundata,
                                                                  template );
            
            JspService service = (JspService)TurbineServices.getInstance()
                                             .getService(JspService.SERVICE_NAME);
            // this is only necessary if we ddon't run in a JSP page environment
            // but better be safe than sorry...
            service.addDefaultObjects(rundata);

            // Allow access to portlet from .jsp template
            rundata.getRequest().setAttribute("portlet", this);

            // Add js_peid out of convenience
            rundata.getRequest().setAttribute("js_peid", this.getID());

	    // Retrieve and execute the action object
	    String actionName = getPortletConfig().getInitParameter("action");
	    if (actionName != null) 
            {
		try 
                {
                    if (Log.getLogger().isDebugEnabled())
                    {
                        Log.debug("JspPorlet: Executing action [" + actionName + "] for portlet [" + this.getName() + "]");
                    }
		    ActionLoader.getInstance().exec(rundata, actionName);
		} 
                catch( Exception e) 
                {
		    Log.error(e);
		}
	    }
            
            // handle request
            service.handleRequest(rundata, locatedTemplate);
            
        } catch (Exception e) {
            String message = "JspPortlet: Could not include the following JSP Page:  " + template + " : " + e.getMessage();
            Log.error( message, e );
            return new StringElement( message );
        }

        return new ElementContainer();
    }

}
