/* ====================================================================
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 2000-2001 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "Apache" and "Apache Software Foundation" and
 *     "Apache Jetspeed" must not be used to endorse or promote products
 *    derived from this software without prior written permission. For
 *    written permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache" or
 *    "Apache Jetspeed", nor may "Apache" appear in their name, without
 *    prior written permission of the Apache Software Foundation.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 */

package org.apache.jetspeed.portal.portlets;

//Element Construction Set
import org.apache.ecs.html.*;
import org.apache.ecs.ConcreteElement;
import org.apache.ecs.ElementContainer;
import org.apache.ecs.StringElement;

//Jetspeed stuff
import org.apache.jetspeed.portal.*;
import org.apache.jetspeed.util.*;
import org.apache.jetspeed.cache.disk.*;


//turbine
import org.apache.turbine.util.*;

//standard java stuff
import java.net.*;
import java.io.*;

//ecs stuff
import org.apache.ecs.*;
import org.apache.ecs.html.*;


/**
 * <p>Serve a static URL (typically a HTML fragment)</p>
 *
 @author <a href="mailto:burton@apache.org">Kevin A. Burton</a>
 @author <a href="mailto:sgala@apache.org">Santiago Gala</a>
 @version $Id: FileServerPortlet.java,v 1.25 2002/09/27 19:54:26 taylor Exp $ 
*/
public class FileServerPortlet extends FileWatchPortlet {

    /**
    */
    public void init() throws PortletException {

        // first make sure we propagate init
        super.init();
        
        PortletConfig config = this.getPortletConfig();
        
        //fetch the URL as a String...

        try {

            this.setContent( new JetspeedClearElement( this.getURL(  this.getPortletConfig().getURL() ) ) );

        } catch (Exception e) {
            throw new PortletException( e.getMessage() );
        }
            
       
    }

    /**
    */
    private String getURL(String url) throws IOException {

        int CAPACITY = 1024;

        Reader rdr = JetspeedDiskCache.getInstance()
            .getEntry( url ).getReader();
        StringBuffer buffer = new StringBuffer();

        //now process the Reader...
        char[] chars = new char[CAPACITY];

        int readCount = 0;
        while( ( readCount = rdr.read( chars )) > 0 ) {

            buffer.append( chars, 0, readCount);
        }

        rdr.close();


        return buffer.toString();
            

    }

}
