/* ====================================================================
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 2000-2001 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "Apache" and "Apache Software Foundation" and
 *     "Apache Jetspeed" must not be used to endorse or promote products
 *    derived from this software without prior written permission. For
 *    written permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache" or
 *    "Apache Jetspeed", nor may "Apache" appear in their name, without
 *    prior written permission of the Apache Software Foundation.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 */

package org.apache.jetspeed.portal;

//standard java stuff
import java.util.Map;
import java.util.Enumeration;

/**
 * The PortletSet is basically a wrapper around an array of portlets. It provides
 * runtime context for a set of portlets.
 * A portlet can get its current set by calling via its PortletConfig
 * 
 * @author <a href="mailto:raphael@apache.org">Raphal Luta</a>
 * @author <a href="mailto:burton@apache.org">Kevin A. Burton</a>
 * @version $Id: PortletSet.java,v 1.25 2002/03/11 07:22:11 taylor Exp $
 */
public interface PortletSet extends Portlet
{
    /**
     * Return the current controller for this set
     */
    public PortletController getController();

    /**
     * Set the controller for this set
     */
    public void setController(PortletController controller);

    /**
     * Returns the number of portlets currently stored in this set
     */
    public int size();

    /**
     * Returns the portlet set as an array.
     */
    public Portlet[] toArray();

    /**
     * Returns the Portlet at position pos
     */
    public Portlet getPortletAt(int pos);

    /**
     * Returns the Portlet with the given id
     */
    public Portlet getPortletByID(String id);

    /**
    Returns the Portlet with the given name
    */
    public Portlet getPortletByName(String name);

    /**
     * Returns the portlet set as an Enumeration
     */
    public Enumeration getPortlets();

    /**
     * Add a portlet to this set.It updates its config to modify the current set
     */
    public void addPortlet(Portlet portlet);

    /**
     * Add a portlet to this set.It updates its config to modify the current set
     */
    public void addPortlet(Portlet portlet, int position);

    /**
     * Add a portlet to this set.It updates its config to modify the current set
     */
    public void addPortlet(Portlet portlet, Constraints constraints);

    /**
     * Add a portlet to this set.It updates its config to modify the current set
     */
    public void addPortlet(Portlet portlet, Constraints constraints, int position);

    /**
     * The PortletSetConstraints is used to associate layout constraints with a 
     * Portlet within a Set. These constraints may be used by the PortletController
     * to render the layout of any given PortletSet correctly.
     */
    public interface Constraints extends Map
    {   
        /** Get the column the portlet should be displayed in
         *
         * @return a positive column number or null
         */
        public Integer getColumn();
        
        /** Set the column the portlet should be displayed in. This
         *  integer must be positive
         *
         * @param col the column position
         */
        public void setColumn(Integer col) throws IllegalArgumentException;
        
        /** Get the row the portlet should be displayed in
         *
         * @return a positive row number or null
         */
        public Integer getRow();
        
        /** Set the row the portlet should be displayed in. This
         *  integer must be positive
         *
         * @param row the column position
         */
        public void setRow(Integer row) throws IllegalArgumentException;
    }
}
