/* ====================================================================
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 2000-2001 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "Apache" and "Apache Software Foundation" and
 *     "Apache Jetspeed" must not be used to endorse or promote products
 *    derived from this software without prior written permission. For
 *    written permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache" or
 *    "Apache Jetspeed", nor may "Apache" appear in their name, without
 *    prior written permission of the Apache Software Foundation.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 */

package org.apache.jetspeed.portal;

/**
 * The PortletControl acts both as a decoration around a Portlet or PortletSet
 * and also as the window manager for the enclosed Portlet(Set).
 * As such it controls the operation that may be performed on this portlet
 * and whether the portlet content should be displayed or not.
 * PortletControl also delegates all Portlet and PortletSet methods to its
 * inner object and can thus be transparently cascaded or substituted to
 * a simple portlet wherever in a PSML object tree.
 *
 * @author <a href="mailto:raphael@apache.org">Raphal Luta</a>
 * @version $Id: PortletControl.java,v 1.23 2001/05/07 20:48:25 raphael Exp $
 */
public interface PortletControl extends Portlet, PortletSet
{

    public String  COLOR               = "#CCCCCC";
    public String  BACKGROUND_COLOR    = "#FFFFFF";
    public String  TITLE_COLOR         = "#DDDDDD";
    public String  WIDTH               = "100%";

    /**
     * @return the PortletControl specific configuration
     */
    public PortletControlConfig getConfig();

    /**
     * Sets the PortletControl specific configuration
     * @param conf the new PortletControl configuration
     */
    public void setConfig(PortletControlConfig conf);

    /**
     * Sets the portlet to be managed by this control
     * 
     * @param portlet the new portlet to be managed by the control
     */
    public void setPortlet(Portlet portlet);

    /**
     * Retrieves the portlet managed by this control
     * @return the portlet object managed or null
     */
    public Portlet getPortlet();

    /**
     * Initializes the control and associates it with a portlet
     *
     * @param portlet the portlet to be managed by this control
     */
    public void init( Portlet portlet );

    /**
     * Returns the color to use for displaying the portlet text
     * 
     * This method is deprecated and is only useful for ECS
     * based Control implementation
     * @deprecated
     * @return the text color value in HTML format (#RRGGBB)
     */
    public String getColor();

    /**
     * Sets the color to use for displaying the portlet text
     * 
     * This method is deprecated and is only useful for ECS
     * based Control implementation
     * @deprecated
     * @param color the text color value in HTML format (#RRGGBB)
     */
    public void setColor(String color);

    /**
     * Returns the color to use for displaying the portlet background
     * 
     * This method is deprecated and is only useful for ECS
     * based Control implementation
     * @deprecated
     * @return the text color value in HTML format (#RRGGBB)
     */
    public String getBackgroundColor();

    /**
     * Sets the color to use for displaying the portlet background
     * 
     * This method is deprecated and is only useful for ECS
     * based Control implementation
     * @deprecated
     * @param backgroundColor the background color value in HTML format (#RRGGBB)
     */
    public void setBackgroundColor(String backgroundColor);

    /**
     * Returns the color to use for displaying the portlet title
     * 
     * This method is deprecated and is only useful for ECS
     * based Control implementation
     * @deprecated
     * @return the text color value in HTML format (#RRGGBB)
     */
    public String getTitleColor();

    /**
     * Sets the color to use for displaying the portlet title
     * 
     * This method is deprecated and is only useful for ECS
     * based Control implementation
     * @deprecated
     * @param titleColor the title color value in HTML format (#RRGGBB)
     */
    public void setTitleColor(String titleColor);

    /**
     * Returns the width of the managed portlet relative to the size of
     * portlet control.
     * This method is deprecated and is only useful for ECS
     * based Control implementation
     * @deprecated
     * @return the size value. May be expressed in percentages (eg, "80%")
     */
    public String getWidth();

    /**
     * Sets the width of the managed portlet relative to the size of
     * portlet control.
     * 
     * This method is deprecated and is only useful for ECS
     * based Control implementation
     * @deprecated
     * @param width the width of portlet. Must be a positive, non nul integer
     */
    public void setWidth(int width);

    /**
     * Sets the width of the managed portlet relative to the size of
     * portlet control.
     * 
     * This method is deprecated and is only useful for ECS
     * based Control implementation
     * @deprecated
     * @param width the width of portlet. Must be parseable as a positive, non 
     * nul integer or a percentage
     */
    public void setWidth(String width);
}
