/* ====================================================================
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 2000-2001 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "Apache" and "Apache Software Foundation" and
 *     "Apache Jetspeed" must not be used to endorse or promote products
 *    derived from this software without prior written permission. For
 *    written permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache" or
 *    "Apache Jetspeed", nor may "Apache" appear in their name, without
 *    prior written permission of the Apache Software Foundation.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 */

package org.apache.jetspeed.portal;

/**
 * Trivial implementation of PortletSetConstraints
 *
 * @author <a href="mailto:raphael@apache.org">Raphal Luta</a>
 * @version $Id: BasePortletSetConstraints.java,v 1.2 2001/07/08 20:51:46 raphael Exp $
 */
public class BasePortletSetConstraints extends java.util.HashMap
    implements PortletSet.Constraints
{
    /** Get the column the portlet should be displayed in
     *
     * @return a positive column number or null
     */
    public Integer getColumn()
    {
        Object column = get("column");
        if (column instanceof String)
        {
            try
            {
                column = new Integer(Integer.parseInt((String)column));
                put("column", column);
            }
            catch (Exception e)
            {
                remove("column");
                column=null;
            }
        }
        return (Integer)column;
    }
        
    /** Set the column the portlet should be displayed in. This
     *  integer must be positive
     *
     * @param col the column position
     */
    public void setColumn(Integer col) throws IllegalArgumentException
    {
        if (col.intValue() < 0)
        {
            throw new IllegalArgumentException("Column coordinate must be positive");
        }
        
        put("column",col);
    }

    /** Get the row the portlet should be displayed in
     *
     * @return a positive row number or null
     */
    public Integer getRow()
    {
        Object row = get("row");
        if (row instanceof String)
        {
            try
            {
                row = new Integer(Integer.parseInt((String)row));
                put("row", row);
            }
            catch (Exception e)
            {
                remove("row");
                row = null;
            }
        }
        return (Integer)row;
    }
        
    /** Set the row the portlet should be displayed in. This
     *  integer must be positive
     *
     * @param row the column position
     */
    public void setRow(Integer row) throws IllegalArgumentException
    {
        if (row.intValue() < 0)
        {
            throw new IllegalArgumentException("Row coordinate must be positive");
        }
        
        put("row",row);
    }
}
