/* ====================================================================
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 2000-2001 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "Apache" and "Apache Software Foundation" and
 *     "Apache Jetspeed" must not be used to endorse or promote products
 *    derived from this software without prior written permission. For
 *    written permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache" or
 *    "Apache Jetspeed", nor may "Apache" appear in their name, without
 *    prior written permission of the Apache Software Foundation.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 */

package org.apache.jetspeed.om.security.ldap;

import javax.naming.*;
import javax.naming.directory.*;
import java.util.Vector;
import java.util.Hashtable;
import org.apache.jetspeed.services.ldap.LDAPURL;

/**
 * The Base LDAP Object extending DirContext.
 *
 * @author <a href="mailto:ender@kilicoglu.nom.tr">Ender Kilicoglu</a>
 * @author <a href="mailto:taylor@apache.org">David Sean Taylor</a> 
 * 
 * @version $Id: BaseLDAPObject.java,v 1.1 2002/10/21 22:31:15 taylor Exp $
 */

public class BaseLDAPObject implements DirContext
{
  protected LDAPURL ldapurl;
  protected boolean updated = false;
  protected String Name;
  protected String Id;
  protected Attributes myAttrs;
  protected boolean isNew = false;
  protected BasicAttributes rmAttrs= new BasicAttributes();
  /**
  * Updated Function
  *
  * Return State of updated property
  *
  * @return boolean updated property value
  */
  public boolean getupdated(){
    return this.updated;
  }
  /**
  * ID Function
  *
  * Return Value of ID property
  *
  * @return String ID property value
  */
  public String getId() {
    return Id;
  }
  /**
  * ID Function
  *
  * Set Value of ID property
  *
  * @param Id ID property value
  */
  public void setId(String Id) {
    this.Id = Id;
  }
  public String getName() {
    return Name;
  }
  public void setName(String Name) {
//     throw new java.lang.UnsupportedOperationException();
  }
  public LDAPURL getldapurl(){
    return ldapurl;
  }
  public boolean getIsNew() {
    return isNew;
  }

//UTIL Funcs
  protected void setutil(String field, String value){
    myAttrs.remove(field);
    myAttrs.put(field,value);
    updated = true;
  }
  protected String getutil(String field){
    if (myAttrs.get(field) == null){
      return new String("");
    }
    else {
      try{
        return myAttrs.get(field).getAll().next().toString();
      } catch (NamingException e) {
          return new String("");
      }
    }
  }
  protected Vector getutil(String field,boolean empty){
    Vector values= null;
    String temp;
    if (empty){
      values =new Vector();
    }

    if (!(myAttrs.get(field) == null)){
      try{
        for(NamingEnumeration enum = myAttrs.get(field).getAll(); enum.hasMore(); )
        {
          temp= (String)enum.nextElement();
          if (null!= temp){
            values.add(temp);
          }
        }
      } catch (NamingException e) {
      }
    }
    return values;
  }
  public Attributes getAttributes(String name) throws NamingException {
    if (! name.equals("")) {
        throw new NameNotFoundException();
    }
    return myAttrs;
  }

    public Attributes getAttributes(Name name) throws NamingException {
	return getAttributes(name.toString());
    }

    public Attributes getAttributes(String name, String[] ids)
	throws NamingException {
	if (! name.equals("")) {
	    throw new NameNotFoundException();
	}

	Attributes answer = new BasicAttributes(true);
	Attribute target;
	for (int i = 0; i < ids.length; i++) {
	    target = myAttrs.get(ids[i]);
	    if (target != null) {
		answer.put(target);
	    }
	}
	return answer;
    }

    public Attributes getAttributes(Name name, String[] ids)
	throws NamingException {
	return getAttributes(name.toString(), ids);
    }

    public String toString() {
	return ldapurl.getUrl();
    }

// not used for this example

    public Object lookup(Name name) throws NamingException {
	throw new OperationNotSupportedException();
    }
    public String getNameInNamespace() throws NamingException {
	throw new OperationNotSupportedException();
    }
    public Object lookup(String name) throws NamingException {
	throw new OperationNotSupportedException();
    }

    public void bind(Name name, Object obj) throws NamingException {
	throw new OperationNotSupportedException();
    }

    public void bind(String name, Object obj) throws NamingException {
	throw new OperationNotSupportedException();
    }

    public void rebind(Name name, Object obj) throws NamingException {
	throw new OperationNotSupportedException();
    }

    public void rebind(String name, Object obj) throws NamingException {
	throw new OperationNotSupportedException();
    }

    public void unbind(Name name) throws NamingException {
	throw new OperationNotSupportedException();
    }

    public void unbind(String name) throws NamingException {
	throw new OperationNotSupportedException();
    }

    public void rename(Name oldName, Name newName) throws NamingException {
	throw new OperationNotSupportedException();
    }

    public void rename(String oldName, String newName) throws NamingException {
	throw new OperationNotSupportedException();
    }

    public NamingEnumeration list(Name name) throws NamingException {
	throw new OperationNotSupportedException();
    }

    public NamingEnumeration list(String name) throws NamingException {
	throw new OperationNotSupportedException();
    }

    public NamingEnumeration listBindings(Name name) throws NamingException {
	throw new OperationNotSupportedException();
    }
    public NamingEnumeration listBindings(String name) throws NamingException {
	throw new OperationNotSupportedException();
    }
    public void destroySubcontext(Name name) throws NamingException {
	throw new OperationNotSupportedException();
    }
    public void destroySubcontext(String name) throws NamingException {
	throw new OperationNotSupportedException();
    }
    public Context createSubcontext(Name name) throws NamingException {
	throw new OperationNotSupportedException();
    }
    public Context createSubcontext(String name) throws NamingException {
	throw new OperationNotSupportedException();
    }
    public Object lookupLink(Name name) throws NamingException {
	throw new OperationNotSupportedException();
    }
    public Object lookupLink(String name) throws NamingException {
	throw new OperationNotSupportedException();
    }
    public NameParser getNameParser(Name name) throws NamingException {
	throw new OperationNotSupportedException();
    }
    public NameParser getNameParser(String name) throws NamingException {
	throw new OperationNotSupportedException();
    }
    public String composeName(String name, String prefix)
	    throws NamingException {
	throw new OperationNotSupportedException();
    }

    public Name composeName(Name name, Name prefix)
	    throws NamingException {
	throw new OperationNotSupportedException();
    }

    public Object addToEnvironment(String propName, Object propVal)
	throws NamingException {
	throw new OperationNotSupportedException();
    }
    public Object removeFromEnvironment(String propName)
	throws NamingException {
	throw new OperationNotSupportedException();
    }
    public Hashtable getEnvironment() throws NamingException {
	throw new OperationNotSupportedException();
    }
    public void close() throws NamingException {
	throw new OperationNotSupportedException();
    }
// -- DirContext
    public void modifyAttributes(Name name, int mod_op, Attributes attrs)
	    throws NamingException  {
	throw new OperationNotSupportedException();
    }
    public void modifyAttributes(String name, int mod_op, Attributes attrs)
	    throws NamingException  {
	throw new OperationNotSupportedException();
    }
    public void modifyAttributes(Name name, ModificationItem[] mods)
	    throws NamingException  {
	throw new OperationNotSupportedException();
    }
    public void modifyAttributes(String name, ModificationItem[] mods)
	    throws NamingException  {
	throw new OperationNotSupportedException();
    }
    public void bind(Name name, Object obj, Attributes attrs)
	    throws NamingException  {
	throw new OperationNotSupportedException();
    }

    public void bind(String name, Object obj, Attributes attrs)
	    throws NamingException  {
	throw new OperationNotSupportedException();
    }
    public void rebind(Name name, Object obj, Attributes attrs)
	    throws NamingException  {
	throw new OperationNotSupportedException();
    }
    public void rebind(String name, Object obj, Attributes attrs)
	    throws NamingException  {
	throw new OperationNotSupportedException();
    }
    public DirContext createSubcontext(Name name, Attributes attrs)
	    throws NamingException  {
	throw new OperationNotSupportedException();
    }
    public DirContext createSubcontext(String name, Attributes attrs)
	    throws NamingException  {
	throw new OperationNotSupportedException();
    }

    public DirContext getSchema(Name name) throws NamingException  {
	throw new OperationNotSupportedException();
    }

    public DirContext getSchema(String name) throws NamingException  {
	throw new OperationNotSupportedException();
    }

    public DirContext getSchemaClassDefinition(Name name)
	    throws NamingException  {
	throw new OperationNotSupportedException();
    }

    public DirContext getSchemaClassDefinition(String name)
	    throws NamingException  {
	throw new OperationNotSupportedException();
    }

    public NamingEnumeration search(Name name,
				    Attributes matchingAttributes,
				    String[] attributesToReturn)
	    throws NamingException  {
	throw new OperationNotSupportedException();
    }

    public NamingEnumeration search(String name,
				    Attributes matchingAttributes,
				    String[] attributesToReturn)
	    throws NamingException  {
	throw new OperationNotSupportedException();
    }

    public NamingEnumeration search(Name name,
				    Attributes matchingAttributes)
	    throws NamingException  {
	throw new OperationNotSupportedException();
    }

    public NamingEnumeration search(String name,
				    Attributes matchingAttributes)
	    throws NamingException  {
	throw new OperationNotSupportedException();
    }
    public NamingEnumeration search(Name name,
				    String filter,
				    SearchControls cons)
	    throws NamingException  {
	throw new OperationNotSupportedException();
    }

  public NamingEnumeration search(String name,
                                  String filter,
                                  SearchControls cons)
          throws NamingException  {
      throw new OperationNotSupportedException();
  }

  public NamingEnumeration search(Name name,
                                  String filterExpr,
                                  Object[] filterArgs,
                                  SearchControls cons)
          throws NamingException  {
      throw new OperationNotSupportedException();
  }

  public NamingEnumeration search(String name,
                                  String filterExpr,
                                  Object[] filterArgs,
                                  SearchControls cons)
          throws NamingException  {
      throw new OperationNotSupportedException();
  }

}