/* ====================================================================
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 2000-2001 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "Apache" and "Apache Software Foundation" and
 *     "Apache Jetspeed" must not be used to endorse or promote products
 *    derived from this software without prior written permission. For
 *    written permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache" or
 *    "Apache Jetspeed", nor may "Apache" appear in their name, without
 *    prior written permission of the Apache Software Foundation.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 */

package org.apache.jetspeed.om.security;

import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.util.TurbineException;
import org.apache.turbine.services.factory.FactoryService;
import org.apache.turbine.services.pool.TurbinePool;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.util.RunData;
import org.apache.turbine.services.resources.ResourceService;

import org.apache.jetspeed.services.security.GroupException;
import org.apache.jetspeed.services.resources.JetspeedResources;
import org.apache.jetspeed.services.security.JetspeedSecurityService;

/**
 * Factory class for creating Jetspeed Groups.
 * The group class is configured in the JR.p
 *
 * @author <a href="mailto:taylor@apache.org">David Sean Taylor</a>
 * @version $Id: JetspeedGroupFactory.java,v 1.2 2002/06/28 05:37:31 taylor Exp $  
 */
public class JetspeedGroupFactory
{
    private static final String CONFIG_GROUP_CLASSNAME = "group.class";

    private static String groupClassName = null;
    private static Class groupClass = null;
    
    /**
     * Factory method to create JetspeedGroup instances.  
     *
     *
     * @throws UnknownEntityException when the group instance cant be created.
     * @return Group a new created group.
     */
    public static Group getInstance()
        throws GroupException
    {
        return getInstance(true);
    }

    public static Group getInstance(boolean isNew)
        throws GroupException
    {
        Group group = null;

        if (null == groupClassName)
        {
            try
            {
                ResourceService serviceConf = ((TurbineServices)TurbineServices.getInstance())
                                                         .getResources(JetspeedSecurityService.SERVICE_NAME);
                groupClassName = serviceConf.getString(CONFIG_GROUP_CLASSNAME);                                                             
                groupClass = Class.forName(groupClassName);
            }
            catch(Exception e)
            {
                throw new GroupException(
                    "GroupFactory: Failed to create a Class object for Group implementation: " + e.toString());
            }
        }

        try
        {
            group = (Group)groupClass.newInstance();
            if (group instanceof BaseJetspeedGroup)
            {
                ((BaseJetspeedGroup)group).setNew(isNew);
            }            
        }
        catch(Exception e)
        {
            throw new GroupException("Failed instantiate an Group implementation object: " + e.toString());
        }

        return group;
    }
    

}



