/* ====================================================================
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 2000-2001 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "Apache" and "Apache Software Foundation" and
 *     "Apache Jetspeed" must not be used to endorse or promote products
 *    derived from this software without prior written permission. For
 *    written permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache" or
 *    "Apache Jetspeed", nor may "Apache" appear in their name, without
 *    prior written permission of the Apache Software Foundation.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 */

package org.apache.jetspeed.om.profile;

import org.apache.turbine.util.RunData;

import org.apache.jetspeed.portal.PortletSet;
import org.apache.jetspeed.services.PortalToolkit;
import org.apache.jetspeed.services.PsmlManager;
import org.apache.jetspeed.services.psmlmanager.PsmlManagerService;

/**
    Represents a Profile object specially for importing PSML from one service to another (ex. file -> db or db -> file)
    For getDocument, the provider service provides the PSML document.
    For saveDocument, the consumer service writes the PSML document.

    @author <a href="mailto:taylor@apache.org">David Sean Taylor</a>
    @version $Id: ImportProfile.java,v 1.2 2001/12/06 05:07:15 taylor Exp $
*/

public class ImportProfile  extends BaseProfile implements Profile
{
    private final PsmlManagerService provider;
    private final PsmlManagerService consumer;

    public ImportProfile(PsmlManagerService provider, PsmlManagerService consumer)
    {
        super();
        this.provider = provider;
        this.consumer = consumer;
    }

    public ImportProfile(PsmlManagerService provider, PsmlManagerService consumer, ProfileLocator locator)
    {
        super(locator);
        this.provider = provider;
        this.consumer = consumer;
    }

   /** 
     * @see Object#clone
     * @return an instance copy of this object
     */    
    public Object clone() throws java.lang.CloneNotSupportedException
    {
        return super.clone();
    }

    /**
       Gets the root set of portlets for this profile object.

       @return The root portlet set for this profile.
     */
    public PSMLDocument getDocument()
    {
        synchronized (this)
        {
            if ((this.document == null) || (this.document.getPortlets() == null))
            {
                this.document = provider.getDocument(this);
            }
        }        
        return this.document;
    }

    /**
       stores the resource by merging and rewriting the psml file

       @throws ProfileException if an error occurs storing the profile
    */
    public void store() throws ProfileException
    {
        if (document != null)
        {
            consumer.store(this);
        }
    }

}