/* ====================================================================
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 2000-2001 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "Apache" and "Apache Software Foundation" and
 *     "Apache Jetspeed" must not be used to endorse or promote products
 *    derived from this software without prior written permission. For
 *    written permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache" or
 *    "Apache Jetspeed", nor may "Apache" appear in their name, without
 *    prior written permission of the Apache Software Foundation.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 */

package org.apache.jetspeed.modules.actions;

import junit.framework.*;
import org.apache.cactus.*;

import org.apache.turbine.modules.ActionLoader;
import org.apache.turbine.util.RunData;
import org.apache.turbine.util.RunDataFactory;

/**
 * Tests JLoginUser.
 *
 * @author <a href="mailto:johnny.cass@epiuse.com">Johnny Cass</a>
 * @see JLoginUser
 */
public class TestJLoginUser extends ServletTestCase 
{
    
    /**
     * Defines the testcase name for JUnit.
     *
     * @param name the testcase's name.
     */
    public TestJLoginUser ( String name ) 
    {
        super( name );
    }
    
    /**
     * Start the tests.
     *
     * @param args the arguments. Not used
     */
    public static void main ( String[] args ) 
    {
        junit.ui.TestRunner.main ( new String[] { TestJLoginUser.class.getName () } );
    }
    
    /**
     * Creates the test suite.
     *
     * @return a test suite (<code>TestSuite</code>) that includes all methods
     *         starting with "test"
     */
    public static Test suite () 
    {
        // All methods starting with "test" will be executed in the test suite.
        return new TestSuite ( TestJLoginUser.class );
    }
    
    /**
     * Sets up the test case.
     *
     */
    protected void setUp () throws Exception 
    {
        // Create the RunData object to be used during testing.        
        runData = RunDataFactory.getRunData ( request, response, config );
    }
    
    /**
     * Tests if an invalid user is logged in correctly.
     *
     */
    public void testLoginInvalidUser () throws Exception 
    {        
        // Shouldn't have a user object available at this stage.
        assertNull ( "User should be 'null' since we have not logged in " +
        "yet - runData.getUser () ", runData.getUser () );
        
        // Add parameters to the RunData that will be used to login a non existent user.
        runData.getParameters ().setString ( "username", "" );
        runData.getParameters ().setString ( "password", "" );
        
        // Execute the login action.
        ActionLoader.getInstance ().exec ( runData, "JLoginUser" );
        
        // See if we can find a user object.
        assertNotNull ( "User object not found in RunData - runData.getUser () ",
        runData.getUser () );
        
        // Since the user does not exist, the login should have failed.
        assertEquals ( "Logged in - runData.getUser ().hasLoggedIn ()",
        false, runData.getUser ().hasLoggedIn () );                        
    }
    
    /**
     * Tests if a valid user is logged in correctly.
     *
     */
    public void testLoginValidUser () throws Exception 
    {        
        // Shouldn't have a user object available at this stage.
        assertNull ( "User should be 'null' since we have not logged in " +
        "yet - runData.getUser () ", runData.getUser () );
        
        // Add parameters to the RunData that will be used to login a valid user.
        runData.getParameters ().setString ( "username", "turbine" );
        runData.getParameters ().setString ( "password", "turbine" );
        
        // Execute the login action.
        ActionLoader.getInstance ().exec ( runData, "JLoginUser" );
        
        // See if we can find a user object.
        assertNotNull ( "User object not found in RunData - runData.getUser () ",
        runData.getUser () );
        
        // Since we know the user exists, the login should have been successful/
        assertEquals ( "Not logged in - runData.getUser ().hasLoggedIn ()",
        true, runData.getUser ().hasLoggedIn () );                
    }
    
    private RunData runData = null;
}
