/* ====================================================================
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 2000-2001 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "Apache" and "Apache Software Foundation" and
 *     "Apache Jetspeed" must not be used to endorse or promote products
 *    derived from this software without prior written permission. For
 *    written permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache" or
 *    "Apache Jetspeed", nor may "Apache" appear in their name, without
 *    prior written permission of the Apache Software Foundation.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 */

package org.apache.jetspeed.daemon;

/**
@author <a href="mailto:burton@apache.org">Kevin A. Burton</a>
@version $Id: DaemonEntry.java,v 1.3 2001/03/07 06:42:52 taylor Exp $
*/
public class DaemonEntry {
    
    private String  name;
    private long    interval = 0;
    private String  classname;
    private boolean onstartup = false;
    private boolean hasprocessed = false;
    private int     status = Daemon.STATUS_NOT_PROCESSED;

    public DaemonEntry( String name,
                        long interval,
                        String classname,
                        boolean onstartup ) {
        this.name = name;
        this.interval = interval;
        this.classname = classname;
        this.onstartup = onstartup;

    }
    
    /**
    The "name" of this Daemon.  This is the handle used within Jetspeed
    for representation.
    */
    public String getName() { return this.name; }

    /**
    The amount of time in seconds that this daemon should wait before
    processing again.
    */
    public long getInterval() { return this.interval; }

    /**
    The classname of this daemon
    */
    public String getClassname() { return this.classname; }

    /**
    Determine if this daemon should run on system startup.
    */
    public boolean onStartup() { return this.onstartup; }

    /**
    Return true if this daemon has processed at least once.

    @author <a href="mailto:burton@apache.org">Kevin A. Burton</a>
    @version $Id: DaemonEntry.java,v 1.3 2001/03/07 06:42:52 taylor Exp $
    */
    public boolean hasProcessed() { return this.hasprocessed; }

    public int getStatus() {
        return this.status;
    }
    
}
