/* ====================================================================
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 2001 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "Apache" and "Apache Software Foundation" and
 *    "Apache Jetspeed" must not be used to endorse or promote products
 *    derived from this software without prior written permission. For
 *    written permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache",
 *    "Apache Jetspeed", nor may "Apache" appear in their name, without
 *    prior written permission of the Apache Software Foundation.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 */
package org.apache.jetspeed.util.cms;


import org.apache.turbine.util.RunData;
import org.apache.turbine.util.Log;
import org.apache.turbine.services.pull.ApplicationTool;
import org.apache.turbine.services.TurbineServices;
import java.util.Vector;

import org.apache.jetspeed.om.cms.*;
import org.apache.jetspeed.services.cms.JetspeedCMSException;
import org.apache.jetspeed.services.cms.repository.slide.Utility;
import org.apache.jetspeed.services.cms.CmsService;
import org.apache.jetspeed.services.cms.manager.CmsManager;

/**
 *
 *
 * @author <a href="mailto:clombart@netscape.net">Christophe Lombart</a>
 * @version $Id: CMSLink.java,v 1.2 2002/11/09 19:02:53 raphael Exp $
 */
public class CMSLink implements ApplicationTool
{

    /**
     * Initialize the CMSManager object.
     *
     * @param data This is null, RunData or User depending upon specified tool scope.
     */
    public void init(Object data)
    {
        if (data == null)
        {
            //Log.debug("CMSManager scope is global");
        }
    }

    /**
     * This lets the tool know that it should be
     * refreshed. The tool can perform whatever actions
     * are necessary to refresh itself. This is necessary
     * for sane development where you probably want the
     * tools to refresh themselves on every request.
     */
    public void refresh()
    {
        //Log.debug("Refreshing CMSMmanager : do nothing !");

    }

    public Catalog getCatalog(RunData data, String catalogName)
    {
		try
		{
			// Read the content from the repository
			// Get a reference to the Slide Service
			CmsService service = (CmsService) TurbineServices.getInstance()
			                                  .getService(CmsService.SERVICE_NAME);

	       	// Retrieve the content from Slide and get its properties
	       	String userName = Utility.getUserUri(data.getUser().getUserName());

	       	if (Log.getLogger().isDebugEnabled())
	       	{
				Log.debug("CMSLink - get Content - username : " + userName);
			}
			CmsManager  cmsManager = service.getCmsManager();

			Catalog catalog = (Catalog) cmsManager.getResource(userName, catalogName );
			cmsManager.populateCatalog(userName, catalog, true, true, 1);

			return catalog;
		}
		catch (JetspeedCMSException e)
		{
			data.setMessage(e.getMessage());
			return null;
		}
	}

    public Vector getCatalogs(RunData data, String fromUri, String toUri)
    {
		try
		{
			CmsService service = (CmsService) TurbineServices.getInstance()
											.getService(CmsService.SERVICE_NAME);

			String userName = Utility.getUserUri(data.getUser().getUserName());
			CmsManager  cmsManager = service.getCmsManager();
			Vector catalogs = cmsManager.getCatalogs(userName, fromUri, toUri);
			return catalogs;
		}
		catch (JetspeedCMSException e)
		{
			data.setMessage(e.getMessage());
			return null;
		}
	}
}
