/* ====================================================================
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 2000-2001 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "Apache" and "Apache Software Foundation" and
 *     "Apache Jetspeed" must not be used to endorse or promote products
 *    derived from this software without prior written permission. For
 *    written permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache" or
 *    "Apache Jetspeed", nor may "Apache" appear in their name, without
 *    prior written permission of the Apache Software Foundation.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 */

package org.apache.jetspeed.services.cms.manager;

// JDK
import java.util.Hashtable;

// Turbine
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.util.TurbineException;
import org.apache.turbine.services.resources.TurbineResources;


//Jetspeed
import org.apache.jetspeed.services.cms.CmsService;
import org.apache.jetspeed.services.cms.JetspeedCMSException;
import org.apache.jetspeed.om.cms.Resource;

/**
 * Factory class for creating Jetspeed CmsManager & CMS om classes
 * The Cms classes are configured in the JR.p
 *
 * @author <a href="mailto:christophe.lombart@skynet.be">Christophe Lombart</a>
 */
public class CmsFactory
{

    private static String cmsManagerClassName = null;
    private static Class cmsManagerClass = null;
    private static Hashtable omClasses = new Hashtable();
    

    /**
     * Factory method to create CmsManager instances.
     *
     * @param namespace associated to a CMS repository
     * @throws Exception when the cmsManager instance can't be created.
     * @return CmsManager a new created cmsManager.
     */
    public static CmsManager getCmsManagerInstance(String namespace)
        throws JetspeedCMSException

    {
        CmsManager cmsManager = null;

        if (null == cmsManagerClassName)
        {
            try
            {
            	cmsManagerClassName = TurbineResources.getString(
                                 "services.CmsService.CmsManager." + namespace + ".class");
                                 
                cmsManagerClass = Class.forName(cmsManagerClassName);
            }
            catch(Exception e)
            {
                throw new JetspeedCMSException(
                    "CmsFactory: Failed to create a CmsManager object for CMS implementation: " + e.toString());
            }
        }

        try
        {
            cmsManager = (CmsManager) cmsManagerClass.newInstance();
            cmsManager.init(namespace);

        }
        catch(Exception e)
        {
            throw new JetspeedCMSException("Failed instantiate an CmsManager implementation object: " + e.toString());
        }

        return cmsManager;
    }

    /**
     * Factory method to create Cms objects.<br>
     * It is a generic factory used to create all CMS objects.
     * The parameter is used to get the matching classe define in the JR.prop.
     * 
     * @param CmsOmName Cms object interface name
     * @throws Exception when the cms object instance can't be created.
     * @return Resource a new created cmsManager.
     */
    public static Resource getCmsOmInstance(String CmsOmName)
         throws JetspeedCMSException
    {
        Resource resource = null;
        Class omClass = (Class) omClasses.get(CmsOmName);
        
        if (null == omClass)
        {
            try
            {
            	String omClassName = TurbineResources.getString(
                                 "services.CmsService.om." + CmsOmName + ".class");
                                 
                omClass = Class.forName(omClassName);
                omClasses.put(CmsOmName, omClass);
            }
            catch(Exception e)
            {
                throw new JetspeedCMSException(
                    "CmsFactory: Failed to create a Cms object for : " + e.toString());
            }
        }

        try
        {
            resource = (Resource) omClass.newInstance();

        }
        catch(Exception e)
        {
            throw new JetspeedCMSException("Failed to instantiate an Cms implementation object: " + e.toString());
        }

        return resource;
    
    }

}