package org.apache.jetspeed.portal.controls;

import org.apache.jetspeed.portal.portlets.AbstractVTLPortlet;

// Turbine stuff
import org.apache.turbine.services.velocity.TurbineVelocity;
import org.apache.turbine.util.RunData;
import org.apache.turbine.util.DynamicURI;

// Jetspeed stuff
import org.apache.jetspeed.portal.Portlet;
import org.apache.jetspeed.portal.PortletControl;
import org.apache.jetspeed.util.MimeType;
import org.apache.jetspeed.util.URILookup;
import org.apache.jetspeed.util.JetspeedException;

// Ecs stuff
import org.apache.ecs.ConcreteElement;
import org.apache.ecs.StringElement;

// Velocity Stuff
import org.apache.velocity.context.Context;

/**
A Velocity based portlet control with added funtionalities
like min/max/conf/restore/close buttons.

you need this lines in jetspeed-config.jcfg:

    <portlet-control-registry>

       <portlet-control-entry name="VTLTitlePortletControl">
           <classname>org.apache.jetspeed.portal.controls.VTLTitlePortletControl</classname>
           <meta-info>
               <title>VTLPortletControl</title>
           </meta-info>
           <media-type ref="html"/>
       </portlet-control-entry>

    </portlet-control-registry>


and (optional) in JetspeedResources.properties:

    portletcontrol.default.classname=org.apache.jetspeed.portal.controls.VTLTitlePortletControl

@author <a href="mailto:re_carrasco@bco011.sonda.cl">Roberto Carrasco</a>
*/
public class VTLTitlePortletControl extends PortletControl
{
    /**
    Only HTML ...
    */
    public boolean supportsType( MimeType mimeType )
    {
        return mimeType == MimeType.HTML;   
    }


    /**
    */
    public ConcreteElement getContent( RunData rundata )
    {
        // Get the data here to allow the portlet to change some internal state
        Portlet portlet = getPortlet();
        String  portletName = portlet.getName();
        ConcreteElement portletContent = portlet.getContent( rundata );

        // default links for buttons (means non visible)
        String hrefConfigure = "";
        String hrefMinimize  = "";
        String hrefRestore   = "";
        String hrefMaximize  = "";
        String hrefClose     = "";

        // i don't like this, but ...
        if( portlet instanceof AbstractVTLPortlet)
        {
            // only AbstractVTLPortlet gives me this functionality
            AbstractVTLPortlet xPortlet = (AbstractVTLPortlet)portlet;
    
            // configure button
            if( xPortlet.getAllowEdit( rundata ) )
            {
                hrefConfigure=new DynamicURI( rundata )
                                    .addPathInfo("portlet", portletName)
                                    .addPathInfo("button","configure")
                                    .toString();
            }
    
            // minimize/restore button
            if( xPortlet.getAllowMinimize( rundata ) )
            {
                if( xPortlet.isMinimized( rundata ) )
                {
                    hrefRestore=new DynamicURI( rundata )
                                    .addPathInfo("action", "portlets.RestorePortlet")
                                    .addPathInfo("portletName", portletName)
                                    .toString();
                }
                else
                {
                    hrefMinimize=new DynamicURI( rundata )
                                    .addPathInfo("action", "portlets.MinimizePortlet")
                                    .addPathInfo("portletName", portletName)
                                    .toString();
                }
            }
    
            // maximize button
            if( xPortlet.getAllowMaximize( rundata ) )
            {
                hrefMaximize=new DynamicURI( rundata )
                                    .addPathInfo("portlet", portletName)
                                    .addPathInfo("button","maximize")
                                    .toString();
            }
    
            // close button
            if( xPortlet.getAllowClose( rundata ) )
            {
                hrefClose=new DynamicURI( rundata )
                                    .addPathInfo("action", "portlets.ClosePortlet")
                                    .addPathInfo("portletName", portletName)
                                    .toString();
            }
        }

        // Hmmm, let's works like TitlePortletControl
        else
        {
            if ( portlet.getAllowEdit( rundata ) )
            {
                try 
                {
                      hrefConfigure = URILookup.getURI( URILookup.TYPE_INFO,
                                                        URILookup.SUBTYPE_MARK, 
                                                        portlet, rundata );
                } 
                catch (JetspeedException e) {}
            }

            if ( portlet.getAllowMaximize( rundata ) )
            {
                try 
                {
                      hrefMaximize = URILookup.getURI( URILookup.TYPE_HOME,
                                                       URILookup.SUBTYPE_MAXIMIZE,
                                                       portlet, rundata );
                } 
                catch (JetspeedException je) {}
            }
        }

        // to render we need just a blank context object
        Context context = TurbineVelocity.getContext();

        // put buttons in the context
        context.put( "hrefConfigure",  hrefConfigure );
        context.put( "hrefMinimize",   hrefMinimize );
        context.put( "hrefRestore",    hrefRestore );
        context.put( "hrefMaximize",   hrefMaximize );
        context.put( "hrefClose",      hrefClose );

        // the whole area used by portlet + borders + title
        context.put( "panelColor",     this.getColor() );
        context.put( "panelWidth",     this.getWidth() );

        // the title area
        context.put( "titleText",      getPortlet().getTitle() );
        context.put( "titleBgColor",   this.getTitleColor() );

        // the portlet area
        context.put( "portletBgColor", this.getBackgroundColor() );

        // the portlet content
        context.put( "portletContent", portletContent );

        // let velocity handle look&feel
        // TODO: get theme from user's preferences
        String theme = "VTLDefaultTheme.vm";
        String s = null;
        try 
        {
            s = TurbineVelocity.handleRequest(context, "controls/" + theme);
        }
        catch( Exception e )
        {
            s = e.toString();
        }

        return new StringElement( s );
    }

}

