/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jcs.auxiliary.remote;

import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.server.ExportException;
import java.rmi.server.UnicastRemoteObject;
import org.apache.jcs.access.exception.ObjectExistsException;
import org.apache.jcs.access.exception.ObjectNotFoundException;
import org.apache.jcs.auxiliary.remote.behavior.IRemoteCacheConstants;
import org.apache.jcs.auxiliary.remote.behavior.IRemoteCacheListener;
import org.apache.jcs.engine.CacheElement;
import org.apache.jcs.engine.behavior.ICacheElement;
import org.apache.jcs.engine.behavior.ICacheObserver;
import org.apache.jcs.engine.behavior.ICacheService;

public class RemoteCacheClientTest
implements IRemoteCacheListener,
IRemoteCacheConstants {
    ICacheObserver watch;
    ICacheService cache;
    final String host;
    final int port;
    final int count;
    protected static byte listenerId = 0;

    public int getRemoteType() throws IOException {
        return 0;
    }

    public RemoteCacheClientTest(int count) throws MalformedURLException, NotBoundException, IOException {
        this(count, true, true, false);
    }

    public RemoteCacheClientTest(int count, boolean write, boolean read, boolean delete) throws MalformedURLException, NotBoundException, IOException {
        this("", 1099, count, write, read, delete);
    }

    public RemoteCacheClientTest(String host, int port, int count, boolean write, boolean read, boolean delete) throws MalformedURLException, NotBoundException, IOException {
        this.count = count;
        this.host = host;
        this.port = port;
        ExportException ee = null;
        try {
            UnicastRemoteObject.exportObject(this);
            ee = null;
        }
        catch (ExportException e) {
            ee = e;
        }
        String service = System.getProperty("remote.cache.service.name");
        if (service == null) {
            service = IRemoteCacheConstants.REMOTE_CACHE_SERVICE_VAL;
        }
        String registry = "//" + host + ":" + port + "/" + service;
        RemoteCacheClientTest.p("looking up server " + registry);
        Remote obj = Naming.lookup(registry);
        RemoteCacheClientTest.p("server found");
        this.cache = (ICacheService)((Object)obj);
        this.watch = (ICacheObserver)((Object)obj);
        RemoteCacheClientTest.p("subscribing to the server");
        this.watch.addCacheListener("testCache", this);
        CacheElement cb = new CacheElement("testCache", (Serializable)((Object)"testKey"), (Serializable)((Object)"testVal"));
        int i = 0;
        while (i < count) {
            cb = new CacheElement("testCache", (Serializable)((Object)("" + i)), (Serializable)((Object)("" + i)));
            if (delete) {
                RemoteCacheClientTest.p("deleting a cache item from the server " + i);
                this.cache.remove(cb.getCacheName(), cb.getKey());
            }
            if (write) {
                RemoteCacheClientTest.p("putting a cache bean to the server " + i);
                try {
                    this.cache.update(cb);
                }
                catch (ObjectExistsException oee) {
                    RemoteCacheClientTest.p(((Throwable)((Object)oee)).toString());
                }
            }
            if (read) {
                try {
                    ICacheElement val = this.cache.get(cb.getCacheName(), cb.getKey());
                    RemoteCacheClientTest.p("get " + cb.getKey() + " returns " + val);
                }
                catch (ObjectNotFoundException onfe) {
                    // empty catch block
                }
            }
            ++i;
        }
    }

    public void handlePut(ICacheElement cb) throws IOException {
        RemoteCacheClientTest.p("handlePut> cb=" + cb);
    }

    public void handleRemove(String cacheName, Serializable key) throws IOException {
        RemoteCacheClientTest.p("handleRemove> cacheName=" + cacheName + ", key=" + key);
    }

    public void handleRemoveAll(String cacheName) throws IOException {
        RemoteCacheClientTest.p("handleRemove> cacheName=" + cacheName);
    }

    public void handleDispose(String cacheName) throws IOException {
        RemoteCacheClientTest.p("handleDispose> cacheName=" + cacheName);
    }

    public static void main(String[] args) throws Exception {
        int count = 0;
        boolean read = false;
        boolean write = false;
        boolean delete = false;
        int i = 0;
        while (i < args.length) {
            if (args[i].startsWith("-")) {
                if (!read) {
                    boolean bl = read = args[i].indexOf("r") != -1;
                }
                if (!write) {
                    boolean bl = write = args[i].indexOf("w") != -1;
                }
                if (!delete) {
                    delete = args[i].indexOf("d") != -1;
                }
            } else {
                count = Integer.parseInt(args[i]);
            }
            ++i;
        }
        RemoteCacheClientTest client = new RemoteCacheClientTest(count, write, read, delete);
    }

    public void setListenerId(byte id) throws IOException {
        listenerId = id;
        RemoteCacheClientTest.p("listenerId = " + id);
    }

    public byte getListenerId() throws IOException {
        return listenerId;
    }

    private static void p(String s) {
        System.out.println(s);
    }
}

