/*
 * Decompiled with CFR 0.152.
 */
package test.ojb.odmg;

import junit.framework.Assert;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import ojb.broker.PersistenceBrokerFactory;
import ojb.odmg.OJB;
import ojb.odmg.TransactionImpl;
import org.odmg.DList;
import org.odmg.Database;
import org.odmg.ODMGException;
import org.odmg.OQLQuery;
import org.odmg.Transaction;
import test.ojb.odmg.Person;
import test.ojb.odmg.PersonImpl;

public class ProxyTest
extends TestCase {
    private static Class CLASS = class$test$ojb$odmg$ProxyTest == null ? (class$test$ojb$odmg$ProxyTest = ProxyTest.class$("test.ojb.odmg.ProxyTest")) : class$test$ojb$odmg$ProxyTest;
    private String databaseName;
    static /* synthetic */ Class class$test$ojb$odmg$ProxyTest;
    static /* synthetic */ Class class$test$ojb$odmg$PersonImpl;

    public static void main(String[] args) {
        String[] arr = new String[]{CLASS.getName()};
        TestRunner.main((String[])arr);
    }

    public ProxyTest(String name) {
        super(name);
    }

    public void setUp() {
        this.databaseName = PersistenceBrokerFactory.getConfiguration().getRepositoryFilename();
    }

    public void tearDown() {
        this.databaseName = null;
    }

    public void testLoading() {
        try {
            OJB odmg = OJB.getInstance();
            Database db = odmg.newDatabase();
            try {
                db.open(this.databaseName, 2);
            }
            catch (ODMGException ex) {
                Assert.fail((String)("ODMGException: " + ex.getMessage()));
            }
            PersonImpl mum = new PersonImpl();
            mum.setFirstname("Macy");
            mum.setLastname("Gray");
            PersonImpl dad = new PersonImpl();
            dad.setFirstname("Paul");
            dad.setLastname("Gray");
            PersonImpl kevin = new PersonImpl();
            kevin.setFirstname("Kevin");
            kevin.setLastname("Gray");
            kevin.setMother(mum);
            kevin.setFather(dad);
            Transaction tx = odmg.newTransaction();
            tx.begin();
            tx.lock(kevin, 4);
            tx.commit();
            tx = odmg.newTransaction();
            tx.begin();
            ((TransactionImpl)tx).getBroker().clearCache();
            OQLQuery qry = odmg.newOQLQuery();
            qry.create("select a from " + (class$test$ojb$odmg$PersonImpl == null ? (class$test$ojb$odmg$PersonImpl = ProxyTest.class$("test.ojb.odmg.PersonImpl")) : class$test$ojb$odmg$PersonImpl).getName() + " where firstname=\"Kevin\"");
            DList result = (DList)qry.execute();
            Person boy = (Person)result.get(0);
            Assert.assertEquals((Object)boy.getFirstname(), (Object)kevin.getFirstname());
            Assert.assertEquals((Object)boy.getFather().getFirstname(), (Object)dad.getFirstname());
            Assert.assertEquals((Object)boy.getMother().getFirstname(), (Object)mum.getFirstname());
            tx.commit();
            try {
                db.close();
            }
            catch (ODMGException ex) {
                Assert.fail((String)("ODMGException: " + ex.getMessage()));
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            Assert.fail((String)t.getMessage());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

