/*
 * Decompiled with CFR 0.152.
 */
package test.ojb.broker;

import java.util.Collection;
import junit.framework.Assert;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import ojb.broker.Identity;
import ojb.broker.PersistenceBroker;
import ojb.broker.PersistenceBrokerException;
import ojb.broker.PersistenceBrokerFactory;
import ojb.broker.query.Criteria;
import ojb.broker.query.Query;
import ojb.broker.query.QueryByExample;
import ojb.broker.query.QueryFactory;
import test.ojb.broker.Article;
import test.ojb.broker.BookArticle;
import test.ojb.broker.CdArticle;
import test.ojb.broker.InterfaceArticle;
import test.ojb.broker.OrderPosition;
import test.ojb.broker.ProductGroup;
import test.ojb.broker.ProductGroupProxy;

public class PolymorphicExtents
extends TestCase {
    PersistenceBroker broker;
    private static Class CLASS = class$test$ojb$broker$PolymorphicExtents == null ? (class$test$ojb$broker$PolymorphicExtents = PolymorphicExtents.class$("test.ojb.broker.PolymorphicExtents")) : class$test$ojb$broker$PolymorphicExtents;
    private int testId = 88882;
    static /* synthetic */ Class class$test$ojb$broker$PolymorphicExtents;
    static /* synthetic */ Class class$test$ojb$broker$InterfaceArticle;

    public static void main(String[] args) {
        String[] arr = new String[]{CLASS.getName()};
        TestRunner.main((String[])arr);
    }

    public PolymorphicExtents(String name) {
        super(name);
    }

    protected Article createArticle(int id) {
        Article a = new Article();
        a.setArticleId(id);
        a.setArticleName("New Funny Article " + id);
        a.setIsSelloutArticle(true);
        a.setMinimumStock(100);
        a.setOrderedUnits(17);
        a.setPrice(0.45);
        a.setProductGroupId(1);
        a.setStock(234);
        a.setSupplierId(4);
        a.setUnit("bottle");
        ProductGroup tmpPG = new ProductGroup();
        tmpPG.setId(1);
        Identity pgID = new Identity(tmpPG);
        ProductGroupProxy pgProxy = new ProductGroupProxy(pgID);
        a.setProductGroup(pgProxy);
        return a;
    }

    public void setUp() {
        this.broker = PersistenceBrokerFactory.createPersistenceBroker();
    }

    public void tearDown() {
        try {
            this.broker.clearCache();
        }
        catch (PersistenceBrokerException persistenceBrokerException) {
            // empty catch block
        }
    }

    public void testCollectionByQuery() {
        try {
            Criteria crit = new Criteria();
            crit.addEqualTo("articleName", "Hamlet");
            Query q = QueryFactory.newQuery(class$test$ojb$broker$InterfaceArticle == null ? (class$test$ojb$broker$InterfaceArticle = PolymorphicExtents.class$("test.ojb.broker.InterfaceArticle")) : class$test$ojb$broker$InterfaceArticle, crit);
            Collection result = this.broker.getCollectionByQuery(q);
            Assert.assertNotNull((String)"should return at least one item", (Object)result);
            Assert.assertTrue((String)"should return at least one item", (result.size() > 0 ? 1 : 0) != 0);
        }
        catch (Throwable t) {
            Assert.fail((String)t.getMessage());
        }
    }

    public void testCollectionRetrieval() {
        try {
            ProductGroup example = new ProductGroup();
            example.setId(5);
            ProductGroup productGroup = (ProductGroup)this.broker.getObjectByQuery(QueryFactory.newQuery(example));
        }
        catch (Throwable t) {
            Assert.fail((String)t.getMessage());
        }
    }

    public void testExtentByQuery() {
        try {
            Criteria selectAll = null;
            Query q = QueryFactory.newQuery(class$test$ojb$broker$InterfaceArticle == null ? (class$test$ojb$broker$InterfaceArticle = PolymorphicExtents.class$("test.ojb.broker.InterfaceArticle")) : class$test$ojb$broker$InterfaceArticle, selectAll);
            Collection result = this.broker.getCollectionByQuery(q);
            Assert.assertNotNull((String)"should return at least one item", (Object)result);
            Assert.assertTrue((String)"should return at least one item", (result.size() > 0 ? 1 : 0) != 0);
        }
        catch (Throwable t) {
            System.out.println(t.getMessage());
            t.printStackTrace();
            Assert.fail((String)t.getMessage());
        }
    }

    public void testRetrieveObjectByIdentity() {
        try {
            Article example = new Article();
            example.setArticleId(200);
            Identity oid = new Identity(example);
            InterfaceArticle result = (InterfaceArticle)this.broker.getObjectByIdentity(oid);
            Assert.assertNotNull((String)"should find a CD-article", (Object)result);
            Assert.assertTrue((String)"should be of type CdArticle", (boolean)(result instanceof CdArticle));
            example = new Article();
            example.setArticleId(100);
            oid = new Identity(example);
            result = (InterfaceArticle)this.broker.getObjectByIdentity(oid);
            Assert.assertNotNull((String)"should find a Book-article", (Object)result);
            Assert.assertTrue((String)"should be of type BookArticle", (boolean)(result instanceof BookArticle));
        }
        catch (Throwable t) {
            Assert.fail((String)t.getMessage());
        }
    }

    public void testRetrieveReferences() {
        try {
            int i = 1;
            while (i < 4) {
                OrderPosition tmp = new OrderPosition();
                tmp.setId(i);
                Identity oid = new Identity(tmp);
                OrderPosition pos = (OrderPosition)this.broker.getObjectByIdentity(oid);
                ++i;
            }
        }
        catch (Throwable t) {
            Assert.fail((String)t.getMessage());
        }
    }

    public void testSequenceManager() {
        try {
            int uid = this.broker.getUniqueId(class$test$ojb$broker$InterfaceArticle == null ? (class$test$ojb$broker$InterfaceArticle = PolymorphicExtents.class$("test.ojb.broker.InterfaceArticle")) : class$test$ojb$broker$InterfaceArticle, "articleId");
            Article tmp = new Article();
            tmp.setArticleId(uid);
            QueryByExample q = new QueryByExample(tmp);
            InterfaceArticle result = (InterfaceArticle)this.broker.getObjectByQuery(q);
            Assert.assertNull((String)("" + uid + " should be unique"), (Object)result);
            int nextUid = this.broker.getUniqueId(class$test$ojb$broker$InterfaceArticle == null ? (class$test$ojb$broker$InterfaceArticle = PolymorphicExtents.class$("test.ojb.broker.InterfaceArticle")) : class$test$ojb$broker$InterfaceArticle, "articleId");
            Assert.assertEquals((String)"nextUid - uid = 1 !!!", (int)1, (int)(nextUid - uid));
        }
        catch (Throwable t) {
            Assert.fail((String)t.getMessage());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

