/*
 * Decompiled with CFR 0.152.
 */
package test.ojb.broker;

import java.util.Iterator;
import junit.framework.Assert;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import ojb.broker.Identity;
import ojb.broker.PersistenceBroker;
import ojb.broker.PersistenceBrokerException;
import ojb.broker.PersistenceBrokerFactory;
import ojb.broker.query.Criteria;
import ojb.broker.query.QueryByCriteria;
import ojb.broker.util.Logger;
import ojb.broker.util.LoggerFactory;
import ojb.broker.util.ObjectModificationDefaultImpl;
import test.ojb.broker.PerformanceArticle;

public class PerformanceTest
extends TestCase {
    PersistenceBroker broker;
    private static Class CLASS = class$test$ojb$broker$PerformanceTest == null ? (class$test$ojb$broker$PerformanceTest = PerformanceTest.class$("test.ojb.broker.PerformanceTest")) : class$test$ojb$broker$PerformanceTest;
    private Logger logger = LoggerFactory.getLogger("performance");
    private PerformanceArticle[] arr;
    static int articleCount = 10000;
    static int iterations = 2;
    int offsetId = 123456;
    static /* synthetic */ Class class$test$ojb$broker$PerformanceTest;
    static /* synthetic */ Class class$test$ojb$broker$PerformanceArticle;

    public PerformanceTest(String name) {
        super(name);
    }

    private PerformanceArticle createArticle(int id) {
        PerformanceArticle a = new PerformanceArticle();
        a.setArticleId(id);
        a.setArticleName("New Performance Article " + id);
        a.setMinimumStock(100);
        a.setOrderedUnits(17);
        a.setPrice(0.45);
        a.setProductGroupId(111);
        a.setStock(234);
        a.setSupplierId(4);
        a.setUnit("bottle");
        return a;
    }

    public static void main(String[] args) {
        if (args.length > 0) {
            articleCount = Integer.parseInt(args[0]);
        }
        if (args.length > 1) {
            iterations = Integer.parseInt(args[1]);
        }
        String[] arr = new String[]{CLASS.getName()};
        TestRunner.main((String[])arr);
    }

    private PerformanceArticle readArticleByIdentity(int id) throws PersistenceBrokerException {
        Object[] pks = new Object[]{new Integer(id)};
        Identity oid = new Identity(class$test$ojb$broker$PerformanceArticle == null ? (class$test$ojb$broker$PerformanceArticle = PerformanceTest.class$("test.ojb.broker.PerformanceArticle")) : class$test$ojb$broker$PerformanceArticle, pks);
        return (PerformanceArticle)this.broker.getObjectByIdentity(oid);
    }

    public void setUp() {
        this.broker = PersistenceBrokerFactory.createPersistenceBroker();
        this.arr = new PerformanceArticle[articleCount];
        int i = 0;
        while (i < articleCount) {
            PerformanceArticle a;
            this.arr[i] = a = this.createArticle(this.offsetId + i);
            ++i;
        }
    }

    public void tearDown() {
    }

    protected void deleteArticles() throws PersistenceBrokerException {
        long start = System.currentTimeMillis();
        this.broker.beginTransaction();
        int i = 0;
        while (i < articleCount) {
            this.broker.delete(this.arr[i]);
            ++i;
        }
        this.broker.commitTransaction();
        long stop = System.currentTimeMillis();
        this.logger.info("deleting " + articleCount + " Objects: " + (stop - start) + " msec");
    }

    protected void insertNewArticles() throws PersistenceBrokerException {
        ObjectModificationDefaultImpl mod = new ObjectModificationDefaultImpl();
        mod.setNeedsInsert(true);
        long start = System.currentTimeMillis();
        this.broker.beginTransaction();
        int i = 0;
        while (i < articleCount) {
            this.broker.store(this.arr[i], mod);
            ++i;
        }
        this.broker.commitTransaction();
        long stop = System.currentTimeMillis();
        this.logger.info("inserting " + articleCount + " Objects: " + (stop - start) + " msec");
    }

    protected void readArticles() throws PersistenceBrokerException {
        long start = System.currentTimeMillis();
        this.broker.beginTransaction();
        int i = 0;
        while (i < articleCount) {
            PerformanceArticle a = this.readArticleByIdentity(this.offsetId + i);
            ++i;
        }
        this.broker.commitTransaction();
        long stop = System.currentTimeMillis();
        this.logger.info("querying " + articleCount + " Objects: " + (stop - start) + " msec");
    }

    protected void readArticlesByCursor() throws PersistenceBrokerException {
        this.broker.clearCache();
        Criteria c = new Criteria();
        c.addBetween("articleId", new Integer(this.offsetId), new Integer(this.offsetId + articleCount));
        QueryByCriteria q = new QueryByCriteria(class$test$ojb$broker$PerformanceArticle == null ? (class$test$ojb$broker$PerformanceArticle = PerformanceTest.class$("test.ojb.broker.PerformanceArticle")) : class$test$ojb$broker$PerformanceArticle, c);
        long start = System.currentTimeMillis();
        Iterator iter = this.broker.getIteratorByQuery(q);
        int fetchCount = 0;
        while (iter.hasNext()) {
            ++fetchCount;
            PerformanceArticle a = (PerformanceArticle)iter.next();
        }
        long stop = System.currentTimeMillis();
        this.logger.info("fetching " + fetchCount + " Objects: " + (stop - start) + " msec");
    }

    protected void updateExistingArticles() throws PersistenceBrokerException {
        int i = 0;
        while (i < articleCount) {
            this.arr[i].setPrice(this.arr[i].getPrice() * 1.95583);
            ++i;
        }
        ObjectModificationDefaultImpl mod = new ObjectModificationDefaultImpl();
        mod.setNeedsUpdate(true);
        long start = System.currentTimeMillis();
        this.broker.beginTransaction();
        int i2 = 0;
        while (i2 < articleCount) {
            this.broker.store(this.arr[i2], mod);
            ++i2;
        }
        this.broker.commitTransaction();
        long stop = System.currentTimeMillis();
        this.logger.info("updating " + articleCount + " Objects: " + (stop - start) + " msec");
    }

    public void testScenario2() {
        try {
            int i = 0;
            while (i < iterations) {
                this.logger.info("");
                this.insertNewArticles();
                this.updateExistingArticles();
                this.broker.clearCache();
                this.readArticles();
                this.readArticles();
                this.readArticlesByCursor();
                this.deleteArticles();
                ++i;
            }
        }
        catch (Throwable t) {
            this.logger.error(t);
            Assert.fail((String)t.getMessage());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

