/*
 * Decompiled with CFR 0.152.
 */
package ojb.odmg;

import java.lang.reflect.Proxy;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import ojb.broker.Identity;
import ojb.broker.ManageableCollection;
import ojb.broker.PersistenceBroker;
import ojb.broker.PersistenceBrokerException;
import ojb.broker.PersistenceBrokerFactory;
import ojb.broker.TransactionAbortedException;
import ojb.broker.VirtualProxy;
import ojb.broker.accesslayer.IndirectionHandler;
import ojb.broker.accesslayer.MaterializationListener;
import ojb.broker.metadata.ClassDescriptor;
import ojb.broker.metadata.CollectionDescriptor;
import ojb.broker.metadata.ObjectReferenceDescriptor;
import ojb.broker.util.ArrayIterator;
import ojb.broker.util.GUID;
import ojb.odmg.DatabaseImpl;
import ojb.odmg.OJB;
import ojb.odmg.ObjectEnvelope;
import ojb.odmg.ObjectEnvelopeTable;
import ojb.odmg.TransactionTable;
import ojb.odmg.locking.LockManager;
import ojb.odmg.locking.LockManagerFactory;
import org.odmg.LockNotGrantedException;
import org.odmg.Transaction;
import org.odmg.TransactionInProgressException;
import org.odmg.TransactionNotInProgressException;

public class TransactionImpl
implements Transaction,
MaterializationListener {
    private Hashtable myNrm = null;
    private boolean useWriteLocks;
    private String txGUID;
    private PersistenceBroker broker = null;
    private ObjectEnvelopeTable objectEnvelopeTable = null;
    private TransactionTable txTable = null;
    private boolean _isOpen = false;
    private DatabaseImpl curDB;
    private ArrayList registeredIndirectionHandlers = new ArrayList();

    public boolean isOpen() {
        return this._isOpen;
    }

    public void join() {
        this.txTable.remove(Thread.currentThread());
        this.txTable.put(Thread.currentThread(), this);
    }

    public void lock(Object obj, int lockMode) throws LockNotGrantedException {
        if (!this._isOpen) {
            throw new TransactionNotInProgressException();
        }
        LockManager lm = LockManagerFactory.getLockManager();
        if (lockMode == 1) {
            if (!lm.readLock(this, obj)) {
                throw new LockNotGrantedException("Can not lock " + obj + " for READ");
            }
        } else if (lockMode == 4) {
            if (!lm.writeLock(this, obj)) {
                throw new LockNotGrantedException("Can not lock " + obj + " for WRITE");
            }
        } else if (lockMode == 2 && !lm.upgradeLock(this, obj)) {
            throw new LockNotGrantedException("Can not lock " + obj + " for UPGRADE");
        }
        try {
            this.register(obj, lockMode);
        }
        catch (Throwable t) {
            throw new LockNotGrantedException(t.getMessage());
        }
    }

    public void leave() {
        this.txTable.remove(Thread.currentThread());
    }

    private synchronized void doCommit() throws org.odmg.TransactionAbortedException {
        ObjectEnvelope item;
        Enumeration enumeration = this.objectEnvelopeTable.elements();
        while (enumeration.hasMoreElements()) {
            item = (ObjectEnvelope)enumeration.nextElement();
            item.beforeCommit();
        }
        this.objectEnvelopeTable.commit();
        enumeration = this.objectEnvelopeTable.elements();
        while (enumeration.hasMoreElements()) {
            item = (ObjectEnvelope)enumeration.nextElement();
            item.afterCommit();
        }
    }

    private synchronized void doAbort() {
        ObjectEnvelope item;
        Enumeration objectsToAbort = this.objectEnvelopeTable.elements();
        while (objectsToAbort.hasMoreElements()) {
            item = (ObjectEnvelope)objectsToAbort.nextElement();
            item.beforeAbort();
        }
        this.objectEnvelopeTable.rollback();
        objectsToAbort = this.objectEnvelopeTable.elements();
        while (objectsToAbort.hasMoreElements()) {
            item = (ObjectEnvelope)objectsToAbort.nextElement();
            item.afterAbort();
        }
    }

    private synchronized void doClose() {
        Enumeration enumeration = this.objectEnvelopeTable.elements();
        while (enumeration.hasMoreElements()) {
            this.removeLock(((ObjectEnvelope)enumeration.nextElement()).getObject(), 4);
        }
        this.unRegisterFromAllIndirectionHandlers();
        PersistenceBrokerFactory.releaseInstance(this.getBroker());
        this._isOpen = false;
    }

    public void checkpoint() {
        if (!this._isOpen) {
            throw new TransactionNotInProgressException();
        }
        try {
            this.doCommit();
        }
        catch (Throwable t) {
            this.doAbort();
            this.doClose();
            if (t instanceof TransactionAbortedException) {
                throw (TransactionAbortedException)t;
            }
            OJB.getLogger().error(t);
            throw new TransactionAbortedException();
        }
    }

    public boolean tryLock(Object obj, int lockMode) {
        if (!this._isOpen) {
            throw new TransactionNotInProgressException();
        }
        try {
            this.lock(obj, lockMode);
            return true;
        }
        catch (LockNotGrantedException ex) {
            return false;
        }
    }

    private void removeLock(Object obj, int lockType) {
        LockManagerFactory.getLockManager().releaseLock(this, obj);
    }

    public void commit() {
        if (!this._isOpen) {
            throw new TransactionNotInProgressException();
        }
        try {
            this.doCommit();
            this.doClose();
        }
        catch (org.odmg.TransactionAbortedException ex) {
            this.doAbort();
            this.doClose();
            throw ex;
        }
    }

    public void abort() {
        if (!this._isOpen) {
            throw new TransactionNotInProgressException();
        }
        this.doAbort();
        this.doClose();
    }

    public synchronized void begin() {
        if (this._isOpen) {
            throw new TransactionInProgressException();
        }
        this.objectEnvelopeTable = new ObjectEnvelopeTable(this);
        this.myNrm = new Hashtable();
        this._isOpen = true;
    }

    public TransactionImpl(TransactionTable theTxTable, DatabaseImpl theCurrentDB) {
        this.txGUID = new GUID().toString();
        this.txTable = theTxTable;
        this.curDB = theCurrentDB;
        this.useWriteLocks = PersistenceBrokerFactory.getConfiguration().islockAssociationAsWrites();
    }

    public String getGUID() {
        return this.txGUID;
    }

    public void markDelete(Object anObject) {
        ObjectEnvelope otw = this.objectEnvelopeTable.get(anObject);
        otw.setModificationState(otw.getModificationState().markDelete());
    }

    private void register(Object newTxObject, int lockMode) throws LockNotGrantedException, PersistenceBrokerException, IllegalAccessException {
        Object objectToRegister = newTxObject;
        IndirectionHandler handler = null;
        if (newTxObject instanceof VirtualProxy) {
            handler = VirtualProxy.getIndirectionHandler((VirtualProxy)newTxObject);
        } else if (newTxObject instanceof Proxy) {
            handler = (IndirectionHandler)Proxy.getInvocationHandler(newTxObject);
        }
        if (handler != null) {
            if (handler.alreadyMaterialized()) {
                objectToRegister = handler.getRealSubject();
            } else {
                this.registerToIndirectionHandler(handler);
                return;
            }
        }
        if (!this.objectEnvelopeTable.contains(objectToRegister)) {
            this.objectEnvelopeTable.put(objectToRegister, new ObjectEnvelope(objectToRegister, this));
            ClassDescriptor cld = this.getBroker().getClassDescriptor(objectToRegister.getClass());
            int assLockMode = lockMode;
            if (!this.useWriteLocks) {
                assLockMode = 1;
            }
            this.lockReferences(cld, objectToRegister, assLockMode);
            this.lockCollections(cld, objectToRegister, assLockMode);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void lockCollections(ClassDescriptor cld, Object newTxObject, int lockMode) throws IllegalAccessException, PersistenceBrokerException {
        Iterator i = ((AbstractList)cld.getCollectionDescriptors()).iterator();
        while (i.hasNext()) {
            ArrayIterator colIterator;
            CollectionDescriptor cds = (CollectionDescriptor)i.next();
            Object col = cds.getPersistentField().get(newTxObject);
            if (col == null) continue;
            if (col instanceof ManageableCollection) {
                colIterator = ((ManageableCollection)col).ojbIterator();
            } else if (col instanceof Collection) {
                colIterator = ((Collection)col).iterator();
            } else {
                if (!col.getClass().isArray()) {
                    throw new RuntimeException(col.getClass() + " can not be managed by OJB, use Array, Collection or ManageableCollection instead !");
                }
                colIterator = new ArrayIterator(col);
            }
            while (colIterator.hasNext()) {
                this.lock(colIterator.next(), lockMode);
            }
        }
    }

    private void lockReferences(ClassDescriptor cld, Object newTxObject, int lockMode) throws IllegalAccessException, PersistenceBrokerException {
        Iterator i = ((AbstractList)cld.getObjectReferenceDescriptors()).iterator();
        while (i.hasNext()) {
            ObjectReferenceDescriptor rds = (ObjectReferenceDescriptor)i.next();
            Object refObj = rds.getPersistentField().get(newTxObject);
            if (refObj == null) continue;
            this.lock(refObj, lockMode);
        }
    }

    Identity getNrmEntry(String name) {
        return (Identity)this.myNrm.get(name);
    }

    void putNrmEntry(String key, Identity value) {
        this.myNrm.put(key, value);
    }

    boolean unbindNrmEntry(String key) {
        Identity oid = (Identity)this.myNrm.get(key);
        if (oid != null) {
            this.objectEnvelopeTable.remove(oid);
        }
        return this.myNrm.remove(key) != null;
    }

    public void beforeMaterialization(IndirectionHandler handler, Identity oid) {
    }

    public void afterMaterialization(IndirectionHandler handler, Object materializedObject) {
        try {
            this.register(materializedObject, 1);
        }
        catch (Throwable t) {
            throw new LockNotGrantedException(t.getMessage());
        }
        this.unregisterFromIndirectionHandler(handler);
    }

    protected void unRegisterFromAllIndirectionHandlers() {
        int i = this.registeredIndirectionHandlers.size() - 1;
        while (i >= 0) {
            this.unregisterFromIndirectionHandler((IndirectionHandler)this.registeredIndirectionHandlers.get(i));
            --i;
        }
    }

    protected void unregisterFromIndirectionHandler(IndirectionHandler handler) {
        handler.removeListener(this);
        ((AbstractCollection)this.registeredIndirectionHandlers).remove(handler);
    }

    protected void registerToIndirectionHandler(IndirectionHandler handler) {
        handler.addListener(this);
        this.registeredIndirectionHandlers.add(handler);
    }

    public PersistenceBroker getBroker() {
        if (this.broker == null) {
            this.broker = PersistenceBrokerFactory.createPersistenceBroker();
        }
        return this.broker;
    }
}

