/*
 * Decompiled with CFR 0.152.
 */
package ojb.broker.server;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.Socket;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import ojb.broker.Identity;
import ojb.broker.ManageableCollection;
import ojb.broker.PersistenceBroker;
import ojb.broker.PersistenceBrokerException;
import ojb.broker.metadata.ClassDescriptor;
import ojb.broker.query.Query;
import ojb.broker.server.BetterObjectInputStream;
import ojb.broker.server.Request;
import ojb.broker.server.ServerEntry;
import ojb.broker.server.ServerPool;
import ojb.broker.util.Logger;
import ojb.broker.util.LoggerFactory;
import ojb.broker.util.ObjectModification;
import org.odmg.TransactionAbortedException;
import org.odmg.TransactionInProgressException;
import org.odmg.TransactionNotInProgressException;

public class PersistenceBrokerClient
implements PersistenceBroker,
Serializable {
    private static final int invalidId = -1;
    private ServerPool servers;
    private ServerEntry currentServer;
    private int brokerId = -1;
    private static Hashtable cachedMetaData = new Hashtable();
    private Logger logger;

    public PersistenceBrokerClient(ServerPool serverpool) {
        this.servers = serverpool;
        this.currentServer = this.servers.roundRobin();
        this.logger = LoggerFactory.getLogger(this.getClass());
    }

    public PersistenceBrokerClient(ServerEntry server) {
        this.servers = null;
        this.currentServer = server;
        this.logger = LoggerFactory.getLogger(this.getClass());
    }

    private Object callServer(int methodIndex) {
        return this.callServer(methodIndex, this.brokerId, null, null);
    }

    private Object callServer(int methodIndex, Object arg1) {
        return this.callServer(methodIndex, this.brokerId, arg1, null);
    }

    private Object callServer(int methodIndex, Object arg1, Object arg2) {
        return this.callServer(methodIndex, this.brokerId, arg1, arg2);
    }

    private Object callServer(int methodIndex, int brokerid, Object arg1, Object arg2) {
        this.logger.debug("callServer(" + methodIndex + ", " + this.brokerId + ", " + arg1 + ", " + arg2 + ")");
        Socket socket = null;
        try {
            socket = this.currentServer.getConnection();
            OutputStream os = socket.getOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(os);
            Request request = new Request(methodIndex, brokerid, arg1, arg2);
            oos.writeObject(request);
            oos.flush();
            os.flush();
            InputStream is = socket.getInputStream();
            BetterObjectInputStream ois = new BetterObjectInputStream(is);
            Object result = ois.readObject();
            socket.close();
            return result;
        }
        catch (Throwable t) {
            try {
                this.logger.error(t);
                socket.close();
            }
            catch (IOException e) {
                this.logger.error(e);
            }
            this.logger.error(t);
            throw new PersistenceBrokerException(t);
        }
    }

    public void delete(Object obj) throws PersistenceBrokerException {
        Object result = this.callServer(4, obj);
        if (result == null) {
            return;
        }
        if (result instanceof PersistenceBrokerException) {
            throw (PersistenceBrokerException)result;
        }
        throw new PersistenceBrokerException(((Throwable)result).getMessage());
    }

    public void store(Object obj) throws PersistenceBrokerException {
        Object result = this.callServer(11, obj);
        if (result == null) {
            return;
        }
        if (result instanceof PersistenceBrokerException) {
            throw (PersistenceBrokerException)result;
        }
        throw new PersistenceBrokerException(((Throwable)result).getMessage());
    }

    public void abortTransaction() throws TransactionNotInProgressException {
        Object result = this.callServer(1);
        if (!(result instanceof Integer) || (Integer)result != -1) {
            throw new TransactionNotInProgressException();
        }
        this.brokerId = -1;
    }

    public void beginTransaction() throws TransactionInProgressException, TransactionAbortedException {
        Object result;
        if (this.servers != null) {
            this.currentServer = this.servers.roundRobin();
        }
        if ((result = this.callServer(2)) instanceof Integer) {
            this.brokerId = (Integer)result;
        } else {
            if (result instanceof TransactionInProgressException) {
                throw (TransactionInProgressException)result;
            }
            if (result instanceof TransactionAbortedException) {
                throw (TransactionAbortedException)result;
            }
        }
    }

    public void commitTransaction() throws TransactionNotInProgressException, TransactionAbortedException {
        Object result = this.callServer(3);
        if (!(result instanceof Integer) || (Integer)result != -1) {
            if (result instanceof TransactionAbortedException) {
                this.brokerId = -1;
                throw (TransactionAbortedException)result;
            }
            this.brokerId = -1;
            throw new TransactionNotInProgressException();
        }
        this.brokerId = -1;
    }

    public Collection getCollectionByQuery(Query query) throws PersistenceBrokerException {
        Object result = this.callServer(6, query);
        if (result == null) {
            return null;
        }
        if (result instanceof Collection) {
            return (Collection)result;
        }
        if (result instanceof PersistenceBrokerException) {
            throw (PersistenceBrokerException)result;
        }
        throw new PersistenceBrokerException(((Throwable)result).getMessage());
    }

    public ManageableCollection getCollectionByQuery(Class collectionClass, Query query) throws PersistenceBrokerException {
        Object result = this.callServer(5, collectionClass, query);
        if (result == null) {
            return null;
        }
        if (result instanceof ManageableCollection) {
            return (ManageableCollection)result;
        }
        if (result instanceof PersistenceBrokerException) {
            throw (PersistenceBrokerException)result;
        }
        throw new PersistenceBrokerException(((Throwable)result).getMessage());
    }

    public Iterator getIteratorByQuery(Query query) throws PersistenceBrokerException {
        Object result = this.callServer(7, query);
        if (result instanceof Iterator) {
            return (Iterator)result;
        }
        if (result instanceof PersistenceBrokerException) {
            throw (PersistenceBrokerException)result;
        }
        throw new PersistenceBrokerException(((Throwable)result).getMessage());
    }

    public Object getObjectByIdentity(Identity id) throws PersistenceBrokerException {
        Object result = this.callServer(8, id);
        if (result == null) {
            return null;
        }
        if (result instanceof PersistenceBrokerException) {
            throw (PersistenceBrokerException)result;
        }
        if (result instanceof Throwable) {
            throw new PersistenceBrokerException(((Throwable)result).getMessage());
        }
        return result;
    }

    public Object getObjectByQuery(Query query) throws PersistenceBrokerException {
        Object result = this.callServer(9, query);
        if (result == null) {
            return null;
        }
        if (result instanceof PersistenceBrokerException) {
            throw (PersistenceBrokerException)result;
        }
        if (result instanceof Throwable) {
            throw new PersistenceBrokerException(((Throwable)result).getMessage());
        }
        return result;
    }

    public Enumeration getPKEnumerationByQuery(Class primaryKeyClass, Query query) throws PersistenceBrokerException {
        Object result = this.callServer(10, primaryKeyClass, query);
        if (result == null) {
            return null;
        }
        if (result instanceof Enumeration) {
            return (Enumeration)result;
        }
        if (result instanceof PersistenceBrokerException) {
            throw (PersistenceBrokerException)result;
        }
        throw new PersistenceBrokerException(((Throwable)result).getMessage());
    }

    public void store(Object obj, ObjectModification modification) throws PersistenceBrokerException {
        Object result = this.callServer(12, obj, modification);
        if (result == null) {
            return;
        }
        if (result instanceof PersistenceBrokerException) {
            throw (PersistenceBrokerException)result;
        }
        throw new PersistenceBrokerException(((Throwable)result).getMessage());
    }

    public void ping() {
        long start = System.currentTimeMillis();
        Object result = this.callServer(9000);
        long time = System.currentTimeMillis() - start;
        this.logger.info(result.toString() + " time: " + time + " ms");
    }

    public int getUniqueId(Class extent, String attribute) throws PersistenceBrokerException {
        Object result = this.callServer(13, extent, attribute);
        if (result instanceof Integer) {
            return (Integer)result;
        }
        if (result instanceof PersistenceBrokerException) {
            throw (PersistenceBrokerException)result;
        }
        throw new PersistenceBrokerException(((Throwable)result).getMessage());
    }

    public String getUniqueString(Class extent, String attribute) throws PersistenceBrokerException {
        Object result = this.callServer(18, extent, attribute);
        if (result instanceof String) {
            return (String)result;
        }
        if (result instanceof PersistenceBrokerException) {
            throw (PersistenceBrokerException)result;
        }
        throw new PersistenceBrokerException(((Throwable)result).getMessage());
    }

    public boolean hasNext(int iteratorId) throws PersistenceBrokerException {
        Object result = this.callServer(14, new Integer(iteratorId));
        if (result instanceof Boolean) {
            return (Boolean)result;
        }
        throw new PersistenceBrokerException();
    }

    public Object next(int iteratorId) throws PersistenceBrokerException {
        Object result = this.callServer(15, new Integer(iteratorId));
        if (result == null) {
            return null;
        }
        if (result instanceof Exception) {
            throw (PersistenceBrokerException)result;
        }
        return result;
    }

    public void releaseDbResources(int iteratorId) {
        Object object = this.callServer(16, new Integer(iteratorId));
    }

    public void removeFromCache(Object obj) throws PersistenceBrokerException {
        Object result = this.callServer(17, obj);
        if (result == null) {
            return;
        }
        if (result instanceof PersistenceBrokerException) {
            throw (PersistenceBrokerException)result;
        }
        throw new PersistenceBrokerException(((Throwable)result).getMessage());
    }

    public Object getUniqueObject(Class extent, String attribute) throws PersistenceBrokerException {
        Object result = this.callServer(26, extent, attribute);
        if (result == null) {
            return null;
        }
        if (result instanceof PersistenceBrokerException) {
            throw (PersistenceBrokerException)result;
        }
        if (result instanceof Throwable) {
            throw new PersistenceBrokerException(((Throwable)result).getMessage());
        }
        return result;
    }

    public synchronized ClassDescriptor getClassDescriptor(Class clazz) throws PersistenceBrokerException {
        ClassDescriptor cachedCLD = (ClassDescriptor)cachedMetaData.get(clazz.getName());
        if (cachedCLD != null) {
            return cachedCLD;
        }
        this.logger.debug("look up " + clazz.getName());
        Object result = this.callServer(19, clazz);
        if (result instanceof ClassDescriptor) {
            cachedCLD = (ClassDescriptor)result;
            cachedMetaData.put(clazz.getName(), cachedCLD);
            return cachedCLD;
        }
        if (result instanceof PersistenceBrokerException) {
            throw (PersistenceBrokerException)result;
        }
        throw new PersistenceBrokerException(((Throwable)result).getMessage());
    }

    public void clearCache() throws PersistenceBrokerException {
        Object result = this.callServer(21);
        if (result == null) {
            return;
        }
        if (result instanceof PersistenceBrokerException) {
            throw (PersistenceBrokerException)result;
        }
        throw new PersistenceBrokerException(((Throwable)result).getMessage());
    }

    public synchronized void setClassDescriptor(ClassDescriptor modifiedOrNewDescriptor) throws PersistenceBrokerException {
        Object result = this.callServer(20, modifiedOrNewDescriptor);
        if (result == null) {
            String classname = modifiedOrNewDescriptor.getClassOfObject().getName();
            ClassDescriptor cachedCLD = (ClassDescriptor)cachedMetaData.get(classname);
            if (cachedCLD != null) {
                cachedMetaData.put(classname, modifiedOrNewDescriptor);
            }
        } else {
            if (result instanceof PersistenceBrokerException) {
                throw (PersistenceBrokerException)result;
            }
            throw new PersistenceBrokerException(((Throwable)result).getMessage());
        }
    }

    public Class getExtentClass(Class clazz) throws PersistenceBrokerException {
        Object result = this.callServer(24, clazz);
        if (result instanceof Class) {
            return (Class)result;
        }
        if (result instanceof PersistenceBrokerException) {
            throw (PersistenceBrokerException)result;
        }
        throw new PersistenceBrokerException(((Throwable)result).getMessage());
    }

    public void invalidate(Identity oid) throws PersistenceBrokerException {
        Object result = this.callServer(25, oid);
        if (result == null) {
            return;
        }
        if (result instanceof PersistenceBrokerException) {
            throw (PersistenceBrokerException)result;
        }
        throw new PersistenceBrokerException(((Throwable)result).getMessage());
    }

    public long getUniqueLong(Class extent, String attribute) throws PersistenceBrokerException {
        Object result = this.callServer(27, extent, attribute);
        if (result instanceof Long) {
            return (Long)result;
        }
        if (result instanceof PersistenceBrokerException) {
            throw (PersistenceBrokerException)result;
        }
        throw new PersistenceBrokerException(((Throwable)result).getMessage());
    }

    public int getCount(Query query) throws PersistenceBrokerException {
        Object result = this.callServer(28, query);
        if (result instanceof Integer) {
            return (Integer)result;
        }
        if (result instanceof PersistenceBrokerException) {
            throw (PersistenceBrokerException)result;
        }
        throw new PersistenceBrokerException(((Throwable)result).getMessage());
    }

    public Iterator getReportQueryIteratorByQuery(Query query) throws PersistenceBrokerException {
        Object result = this.callServer(29, query);
        if (result instanceof Iterator) {
            return (Iterator)result;
        }
        if (result instanceof PersistenceBrokerException) {
            throw (PersistenceBrokerException)result;
        }
        throw new PersistenceBrokerException(((Throwable)result).getMessage());
    }
}

