/*
 * Decompiled with CFR 0.152.
 */
package ojb.broker.platforms;

import ojb.broker.metadata.JdbcConnectionDescriptor;
import ojb.broker.platforms.Platform;
import ojb.broker.platforms.PlatformDefaultImpl;
import ojb.broker.util.LoggerFactory;

public class PlatformFactory {
    public static Platform getPlatformFor(JdbcConnectionDescriptor jcd) {
        String platform = null;
        try {
            String dbms = jcd.getDbms(null);
            platform = PlatformFactory.getClassnameFor(dbms);
            Class<?> platformClass = Class.forName(platform);
            return (Platform)platformClass.newInstance();
        }
        catch (Throwable t) {
            LoggerFactory.getDefaultLogger().warn("problems with platform " + platform + ": " + t.getMessage());
            LoggerFactory.getDefaultLogger().warn("OJB will use PlatformDefaultImpl instead");
            return new PlatformDefaultImpl();
        }
    }

    private static String getClassnameFor(String platform) {
        String pf = "Default";
        if (platform != null) {
            pf = platform;
        }
        return "ojb.broker.platforms.Platform" + pf + "Impl";
    }
}

