/*
 * Decompiled with CFR 0.152.
 */
package ojb.broker.metadata;

import java.lang.reflect.Proxy;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import ojb.broker.PersistenceBrokerException;
import ojb.broker.accesslayer.ConversionStrategy;
import ojb.broker.accesslayer.RowReader;
import ojb.broker.metadata.ClassDescriptor;
import ojb.broker.metadata.CollectionDescriptor;
import ojb.broker.metadata.DescriptorRepository;
import ojb.broker.metadata.FieldDescriptor;
import ojb.broker.metadata.JdbcConnectionDescriptor;
import ojb.broker.metadata.ObjectReferenceDescriptor;
import ojb.broker.util.Logger;
import ojb.broker.util.LoggerFactory;
import org.xml.sax.AttributeList;
import org.xml.sax.HandlerBase;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class RepositoryXmlHandler
extends HandlerBase {
    private int defIsoLevel = 0;
    private Logger logger;
    private DescriptorRepository m_repository;
    private JdbcConnectionDescriptor m_CurrentJCD;
    private ClassDescriptor m_CurrentCLD;
    private FieldDescriptor m_CurrentFLD;
    private ObjectReferenceDescriptor m_CurrentORD;
    private CollectionDescriptor m_CurrentCOD;
    private String m_CurrentString;
    private String sort;
    private static final Hashtable LiteralsMap = RepositoryXmlHandler.buildLiteralsMap();

    private static int getLiteralId(String literal) throws PersistenceBrokerException {
        try {
            return (Integer)LiteralsMap.get(literal);
        }
        catch (Throwable t) {
            LoggerFactory.getBootLogger().error("unknown literal: " + literal);
            throw new PersistenceBrokerException(t);
        }
    }

    public RepositoryXmlHandler(DescriptorRepository dr) {
        this.m_repository = dr;
        this.logger = LoggerFactory.getLogger(this.getClass());
    }

    public void startDocument() {
        this.logger.debug("startDoc");
    }

    public void endDocument() {
        this.logger.debug("endDoc");
    }

    public void startElement(String name, AttributeList atts) {
        this.m_CurrentString = null;
        try {
            switch (RepositoryXmlHandler.getLiteralId(name)) {
                case 0: {
                    String defIso;
                    if (this.m_repository == null) {
                        this.m_repository = DescriptorRepository.getInstance();
                    }
                    if ((defIso = atts.getValue("isolation")) != null) {
                        this.defIsoLevel = this.getIsoLevel(defIso);
                    }
                    this.logger.debug(" > MappingRepository");
                    break;
                }
                case 1: {
                    this.logger.debug("   > JdbcConnectionDescription");
                    this.m_CurrentJCD = new JdbcConnectionDescriptor();
                    if (this.m_CurrentCLD == null) {
                        this.m_repository.setDefaultJdbcConnection(this.m_CurrentJCD);
                        break;
                    }
                    this.m_CurrentCLD.setConnectionDescriptor(this.m_CurrentJCD);
                    break;
                }
                case 12: {
                    this.logger.debug("  > ClassDescriptor");
                    String isoLevel = atts.getValue("isolation");
                    this.m_CurrentCLD = new ClassDescriptor();
                    if (isoLevel != null) {
                        this.m_CurrentCLD.setIsolationLevel(this.getIsoLevel(isoLevel));
                        break;
                    }
                    this.m_CurrentCLD.setIsolationLevel(this.defIsoLevel);
                    break;
                }
                case 15: {
                    this.logger.debug("    > FieldDescriptor");
                    int id = Integer.parseInt(atts.getValue("id"));
                    this.m_CurrentFLD = new FieldDescriptor(id);
                    this.m_CurrentCLD.addFieldDescriptor(this.m_CurrentFLD);
                    break;
                }
                case 20: {
                    this.logger.debug("    > ReferenceDescriptor");
                    this.m_CurrentORD = new ObjectReferenceDescriptor();
                    this.m_CurrentCLD.addObjectReferenceDescriptor(this.m_CurrentORD);
                    break;
                }
                case 27: {
                    this.logger.debug("    > CollectionDescriptor");
                    this.m_CurrentCOD = new CollectionDescriptor();
                    this.m_CurrentCLD.addCollectionDescriptor(this.m_CurrentCOD);
                    break;
                }
                case 36: {
                    this.sort = atts.getValue("sort");
                    break;
                }
            }
        }
        catch (Exception ex) {
            this.logger.error(ex);
            throw new PersistenceBrokerException(ex);
        }
    }

    public void endElement(String name) {
        try {
            switch (RepositoryXmlHandler.getLiteralId(name)) {
                case 0: {
                    this.logger.debug(" < MappingRepository");
                    break;
                }
                case 1: {
                    this.logger.debug("   < JdbcConnectionDescription");
                    break;
                }
                case 2: {
                    this.logger.debug("     dbms.name: " + this.m_CurrentString);
                    this.m_CurrentJCD.setDbms(this.m_CurrentString);
                    break;
                }
                case 45: {
                    this.logger.debug("     jdbc.level: " + this.m_CurrentString);
                    this.m_CurrentJCD.setJdbcLevel(this.m_CurrentString);
                    break;
                }
                case 5: {
                    this.logger.debug("     schema.name: " + this.m_CurrentString);
                    if (this.m_CurrentString != "") {
                        this.m_CurrentCLD.setSchema(this.m_CurrentString);
                    }
                    break;
                }
                case 6: {
                    this.logger.debug("     driver.name: " + this.m_CurrentString);
                    this.m_CurrentJCD.setDriver(this.m_CurrentString);
                    break;
                }
                case 7: {
                    this.logger.debug("     url.protocol: " + this.m_CurrentString);
                    this.m_CurrentJCD.setProtocol(this.m_CurrentString);
                    break;
                }
                case 8: {
                    this.logger.debug("     url.subprotocol: " + this.m_CurrentString);
                    this.m_CurrentJCD.setSubProtocol(this.m_CurrentString);
                    break;
                }
                case 9: {
                    this.logger.debug("     url.dbalias: " + this.m_CurrentString);
                    this.m_CurrentJCD.setDbAlias(this.m_CurrentString);
                    break;
                }
                case 44: {
                    this.logger.debug("     datasource.name: " + this.m_CurrentString);
                    this.m_CurrentJCD.setDatasourceName(this.m_CurrentString);
                    break;
                }
                case 10: {
                    this.logger.debug("     user.name: " + this.m_CurrentString);
                    this.m_CurrentJCD.setUserName(this.m_CurrentString);
                    break;
                }
                case 11: {
                    this.logger.debug("     user.passwd: " + this.m_CurrentString);
                    this.m_CurrentJCD.setPassWord(this.m_CurrentString);
                    break;
                }
                case 12: {
                    this.logger.debug("  < ClassDescriptor");
                    this.m_CurrentCLD = null;
                    break;
                }
                case 13: {
                    this.logger.debug("     class.name: " + this.m_CurrentString);
                    try {
                        Class<?> c = Class.forName(this.m_CurrentString, true, Thread.currentThread().getContextClassLoader());
                        this.m_CurrentCLD.setClassOfObject(c);
                        this.m_repository.put(c, this.m_CurrentCLD);
                        break;
                    }
                    catch (Exception ex) {
                        this.logger.error(ex);
                        throw new PersistenceBrokerException(ex);
                    }
                }
                case 35: {
                    this.logger.debug("     class.proxy: " + this.m_CurrentString);
                    if (this.m_CurrentString.equals("dynamic")) {
                        Class pc = this.getDynamicProxyClass(this.m_CurrentCLD);
                        this.m_CurrentCLD.setProxyClass(pc);
                        break;
                    }
                    Class<?> pc = Class.forName(this.m_CurrentString, true, Thread.currentThread().getContextClassLoader());
                    this.m_CurrentCLD.setProxyClass(pc);
                    break;
                }
                case 33: {
                    this.logger.debug("     class.extend: " + this.m_CurrentString);
                    Class<?> ec = Class.forName(this.m_CurrentString, true, Thread.currentThread().getContextClassLoader());
                    this.m_CurrentCLD.addExtentClass(ec);
                    break;
                }
                case 34: {
                    this.logger.debug("     ExtendDescriptor: " + this.m_CurrentString);
                    this.m_CurrentCLD.setIsInterface(true);
                    break;
                }
                case 14: {
                    this.logger.debug("     table.name: " + this.m_CurrentString);
                    this.m_CurrentCLD.setTableName(this.m_CurrentString);
                    break;
                }
                case 36: {
                    this.logger.debug("     orderby: " + this.m_CurrentString + ", " + this.sort);
                    boolean isAsc = true;
                    if ("desc".equalsIgnoreCase(this.sort)) {
                        isAsc = false;
                    }
                    if (this.m_CurrentCOD != null) {
                        this.m_CurrentCOD.setOrderBy(this.m_CurrentString);
                        this.m_CurrentCOD.setAscending(isAsc);
                        break;
                    }
                    this.m_CurrentCLD.setOrderby(this.m_CurrentString);
                    break;
                }
                case 30: {
                    this.logger.debug("     conversionStrategy: " + this.m_CurrentString);
                    this.m_CurrentCLD.setConversionStrategy((ConversionStrategy)Class.forName(this.m_CurrentString, true, Thread.currentThread().getContextClassLoader()).newInstance());
                    break;
                }
                case 32: {
                    this.logger.debug("     rowReader: " + this.m_CurrentString);
                    this.m_CurrentCLD.setRowReader((RowReader)Class.forName(this.m_CurrentString, true, Thread.currentThread().getContextClassLoader()).newInstance());
                    break;
                }
                case 15: {
                    this.logger.debug("    < FieldDescriptor");
                    this.m_CurrentFLD = null;
                    break;
                }
                case 16: {
                    this.logger.debug("     field.name: " + this.m_CurrentString);
                    Class c = this.m_CurrentCLD.getClassOfObject();
                    this.m_CurrentFLD.setPersistentField(c, this.m_CurrentString);
                    break;
                }
                case 17: {
                    this.logger.debug("     column.name: " + this.m_CurrentString);
                    this.m_CurrentFLD.setColumnName(this.m_CurrentString);
                    break;
                }
                case 18: {
                    this.logger.debug("     jdbc_type: " + this.m_CurrentString);
                    this.m_CurrentFLD.setColumnType(this.m_CurrentString);
                    break;
                }
                case 19: {
                    this.logger.debug("     PrimaryKey: " + this.m_CurrentString);
                    boolean b = new Boolean(this.m_CurrentString);
                    this.m_CurrentFLD.setPrimaryKey(b);
                    break;
                }
                case 31: {
                    this.logger.debug("     autoincrement: " + this.m_CurrentString);
                    boolean b = new Boolean(this.m_CurrentString);
                    this.m_CurrentFLD.setAutoIncrement(b);
                    break;
                }
                case 20: {
                    this.logger.debug("    < ReferenceDescriptor");
                    this.m_CurrentORD = null;
                    break;
                }
                case 21: {
                    this.logger.debug("     rdfield.name: " + this.m_CurrentString);
                    this.m_CurrentORD.setPersistentField(this.m_CurrentCLD.getClassOfObject(), this.m_CurrentString);
                    break;
                }
                case 22: {
                    this.logger.debug("     referenced.class: " + this.m_CurrentString);
                    this.m_CurrentORD.setItemClass(Class.forName(this.m_CurrentString, true, Thread.currentThread().getContextClassLoader()));
                    break;
                }
                case 23: {
                    this.logger.debug("     fk_descriptor_ids: " + this.m_CurrentString);
                    Vector<Integer> v = new Vector<Integer>();
                    StringTokenizer st = new StringTokenizer(this.m_CurrentString, " ");
                    while (st.hasMoreTokens()) {
                        Integer FieldIndex = new Integer(st.nextToken());
                        v.add(FieldIndex);
                    }
                    this.m_CurrentORD.setForeignKeyFields(v);
                    break;
                }
                case 24: {
                    this.logger.debug("     auto.retrieve: " + this.m_CurrentString);
                    boolean b = new Boolean(this.m_CurrentString);
                    if (this.m_CurrentCOD != null) {
                        this.m_CurrentCOD.setCascadeRetrieve(b);
                        break;
                    }
                    this.m_CurrentORD.setCascadeRetrieve(b);
                    break;
                }
                case 25: {
                    this.logger.debug("     auto.update: " + this.m_CurrentString);
                    boolean b = new Boolean(this.m_CurrentString);
                    if (this.m_CurrentCOD != null) {
                        this.m_CurrentCOD.setCascadeStore(b);
                        break;
                    }
                    this.m_CurrentORD.setCascadeStore(b);
                    break;
                }
                case 26: {
                    this.logger.debug("     auto.delete: " + this.m_CurrentString);
                    boolean b = new Boolean(this.m_CurrentString);
                    if (this.m_CurrentCOD != null) {
                        this.m_CurrentCOD.setCascadeDelete(b);
                        break;
                    }
                    this.m_CurrentORD.setCascadeDelete(b);
                    break;
                }
                case 27: {
                    this.logger.debug("    < CollectionDescriptor");
                    this.m_CurrentCOD = null;
                    break;
                }
                case 28: {
                    this.logger.debug("     cdfield.name: " + this.m_CurrentString);
                    this.m_CurrentCOD.setPersistentField(this.m_CurrentCLD.getClassOfObject(), this.m_CurrentString);
                    break;
                }
                case 29: {
                    this.logger.debug("     items.class: " + this.m_CurrentString);
                    this.m_CurrentCOD.setItemClass(Class.forName(this.m_CurrentString, true, Thread.currentThread().getContextClassLoader()));
                    break;
                }
                case 37: {
                    this.logger.debug("     collection.class: " + this.m_CurrentString);
                    this.m_CurrentCOD.setCollectionClass(Class.forName(this.m_CurrentString, true, Thread.currentThread().getContextClassLoader()));
                    break;
                }
                case 38: {
                    this.logger.debug("     inverse_fk_descriptor_ids: " + this.m_CurrentString);
                    Vector<Integer> v = new Vector<Integer>();
                    StringTokenizer st = new StringTokenizer(this.m_CurrentString, " ");
                    while (st.hasMoreTokens()) {
                        Integer FieldIndex = new Integer(st.nextToken());
                        v.add(FieldIndex);
                    }
                    this.m_CurrentCOD.setForeignKeyFields(v);
                    break;
                }
                case 39: {
                    this.logger.debug("     indirection_table: " + this.m_CurrentString);
                    this.m_CurrentCOD.setIndirectionTable(this.m_CurrentString);
                    break;
                }
                case 40: {
                    this.logger.debug("     fks_pointing_to_items_class: " + this.m_CurrentString);
                    Vector<String> v = new Vector<String>();
                    StringTokenizer st = new StringTokenizer(this.m_CurrentString, " ");
                    while (st.hasMoreTokens()) {
                        String colName = st.nextToken();
                        v.add(colName);
                    }
                    this.m_CurrentCOD.setFksToItemClass(v);
                    break;
                }
                case 41: {
                    this.logger.debug("     fks_pointing_to_this_class: " + this.m_CurrentString);
                    Vector<String> v = new Vector<String>();
                    StringTokenizer st = new StringTokenizer(this.m_CurrentString, " ");
                    while (st.hasMoreTokens()) {
                        String colName = st.nextToken();
                        v.add(colName);
                    }
                    this.m_CurrentCOD.setFksToThisClass(v);
                    break;
                }
                case 42: {
                    this.logger.debug("     proxy: " + this.m_CurrentString);
                    boolean b = new Boolean(this.m_CurrentString);
                    this.m_CurrentCOD.setLazy(b);
                    break;
                }
                case 43: {
                    this.logger.debug("     refreshCollection: " + this.m_CurrentString);
                    boolean b = new Boolean(this.m_CurrentString);
                    this.m_CurrentCOD.setRefresh(b);
                    break;
                }
                case 46: {
                    this.logger.debug("     locking: " + this.m_CurrentString);
                    boolean b = new Boolean(this.m_CurrentString);
                    this.m_CurrentFLD.setLocking(b);
                    break;
                }
                case 47: {
                    this.logger.debug("     refreshReference: " + this.m_CurrentString);
                    boolean b = new Boolean(this.m_CurrentString);
                    this.m_CurrentORD.setRefresh(b);
                    break;
                }
                default: {
                    this.logger.error("Ignoring unknown Element " + name);
                }
            }
        }
        catch (Exception ex) {
            this.logger.error(ex);
            throw new PersistenceBrokerException(ex);
        }
    }

    public void characters(char[] ch, int start, int length) {
        this.m_CurrentString = this.m_CurrentString == null ? new String(ch, start, length) : this.m_CurrentString + new String(ch, start, length);
    }

    public void error(SAXParseException e) throws SAXException {
        this.logger.error(e);
        throw e;
    }

    public void fatalError(SAXParseException e) throws SAXException {
        this.logger.fatal(e);
        throw e;
    }

    public void warning(SAXParseException e) throws SAXException {
        this.logger.warn(e);
        throw e;
    }

    private static final Hashtable buildLiteralsMap() {
        int LiteralCount = 50;
        Hashtable<String, Integer> table = new Hashtable<String, Integer>((int)(1.0 + (double)LiteralCount / 0.75));
        table.put("MappingRepository", new Integer(0));
        table.put("JdbcConnectionDescriptor", new Integer(1));
        table.put("dbms.name", new Integer(2));
        table.put("dbms.hostname", new Integer(3));
        table.put("dbms.port", new Integer(4));
        table.put("schema.name", new Integer(5));
        table.put("driver.name", new Integer(6));
        table.put("url.protocol", new Integer(7));
        table.put("url.subprotocol", new Integer(8));
        table.put("url.dbalias", new Integer(9));
        table.put("user.name", new Integer(10));
        table.put("user.passwd", new Integer(11));
        table.put("ClassDescriptor", new Integer(12));
        table.put("class.name", new Integer(13));
        table.put("class.proxy", new Integer(35));
        table.put("class.extent", new Integer(33));
        table.put("table.name", new Integer(14));
        table.put("orderby", new Integer(36));
        table.put("conversionStrategy", new Integer(30));
        table.put("rowReader", new Integer(32));
        table.put("FieldDescriptor", new Integer(15));
        table.put("field.name", new Integer(16));
        table.put("column.name", new Integer(17));
        table.put("jdbc_type", new Integer(18));
        table.put("PrimaryKey", new Integer(19));
        table.put("autoincrement", new Integer(31));
        table.put("ReferenceDescriptor", new Integer(20));
        table.put("rdfield.name", new Integer(21));
        table.put("referenced.class", new Integer(22));
        table.put("fk_descriptor_ids", new Integer(23));
        table.put("auto.retrieve", new Integer(24));
        table.put("auto.update", new Integer(25));
        table.put("auto.delete", new Integer(26));
        table.put("CollectionDescriptor", new Integer(27));
        table.put("cdfield.name", new Integer(28));
        table.put("items.class", new Integer(29));
        table.put("inverse_fk_descriptor_ids", new Integer(38));
        table.put("collection.class", new Integer(37));
        table.put("indirection_table", new Integer(39));
        table.put("fks_pointing_to_items_class", new Integer(40));
        table.put("fks_pointing_to_this_class", new Integer(41));
        table.put("ExtentDescriptor", new Integer(34));
        table.put("proxy", new Integer(42));
        table.put("refreshCollection", new Integer(43));
        table.put("datasource.name", new Integer(44));
        table.put("jdbc.level", new Integer(45));
        table.put("locking", new Integer(46));
        table.put("refreshReference", new Integer(47));
        table.put("**last**", new Integer(48));
        return table;
    }

    private int getIsoLevel(String isoLevel) {
        if (isoLevel.equals("read-uncommitted")) {
            return 0;
        }
        if (isoLevel.equals("read-committed")) {
            return 1;
        }
        if (isoLevel.equals("repeatable-read")) {
            return 2;
        }
        if (isoLevel.equals("serializable")) {
            return 3;
        }
        this.logger.warn("unknown isolation-level: " + isoLevel + " using RW_UNCOMMITTED as default");
        return this.defIsoLevel;
    }

    private Class getDynamicProxyClass(ClassDescriptor cld) {
        Class clazz = cld.getClassOfObject();
        try {
            Class<?>[] interfaces = clazz.getInterfaces();
            Class<?> proxyClass = Proxy.getProxyClass(clazz.getClassLoader(), interfaces);
            return proxyClass;
        }
        catch (Throwable t) {
            this.logger.warn("can not use dynamic proxy for class " + clazz.getName() + ": " + t.getMessage());
            return null;
        }
    }
}

