/*
 * Decompiled with CFR 0.152.
 */
package ojb.broker.accesslayer;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.sql.ResultSet;
import java.sql.SQLException;
import ojb.broker.PersistenceBroker;
import ojb.broker.PersistenceBrokerException;
import ojb.broker.PersistenceBrokerFactory;
import ojb.broker.accesslayer.ConversionStrategy;
import ojb.broker.accesslayer.JdbcAccess;
import ojb.broker.accesslayer.RowReader;
import ojb.broker.metadata.ClassDescriptor;
import ojb.broker.metadata.FieldDescriptor;
import ojb.broker.util.LoggerFactory;

public class RowReaderDefaultImpl
implements RowReader {
    public Object readObjectFrom(Object[] row, ClassDescriptor descriptor) throws PersistenceBrokerException {
        Object val = null;
        Object fmd = null;
        ClassDescriptor cld = this.selectClassDescriptor(row, descriptor);
        Constructor multiArgsConstructor = cld.getConstructor();
        Object result = null;
        try {
            result = multiArgsConstructor != null ? this.buildWithMultiArgsConstructor(cld, row, multiArgsConstructor) : this.buildWithReflection(cld, row);
            return result;
        }
        catch (PersistenceBrokerException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new PersistenceBrokerException(t);
        }
    }

    public void readObjectArrayFrom(ResultSet rs, ClassDescriptor descriptor, Object[] row) throws PersistenceBrokerException {
        try {
            ConversionStrategy conversion = descriptor.getConversionStrategy();
            FieldDescriptor[] fields = descriptor.getFieldDescriptions();
            int i = 0;
            while (i < row.length) {
                FieldDescriptor fmd = fields[i];
                Object val = JdbcAccess.getObjectFromColumn(rs, fmd);
                row[i] = conversion.sqlToJava(val, fmd);
                ++i;
            }
        }
        catch (Throwable t) {
            throw new PersistenceBrokerException(t);
        }
    }

    protected ClassDescriptor selectClassDescriptor(Object[] row, ClassDescriptor cld) throws PersistenceBrokerException {
        FieldDescriptor fld = cld.getFieldDescriptorByName("ojbConcreteClass");
        if (fld == null) {
            return cld;
        }
        try {
            String concreteClass = (String)row[fld.getColNo() - 1];
            PersistenceBroker broker = PersistenceBrokerFactory.createPersistenceBroker();
            ClassDescriptor result = broker.getClassDescriptor(Class.forName(concreteClass, true, Thread.currentThread().getContextClassLoader()));
            if (result == null) {
                result = cld;
            }
            return result;
        }
        catch (PersistenceBrokerException e) {
            throw e;
        }
        catch (ClassNotFoundException e) {
            throw new PersistenceBrokerException(e);
        }
    }

    protected Object buildWithReflection(ClassDescriptor cld, Object[] row) throws InstantiationException, IllegalAccessException, SQLException {
        Class c = cld.getClassOfObject();
        Object result = c.newInstance();
        FieldDescriptor[] fields = cld.getFieldDescriptions();
        int i = 0;
        while (i < fields.length) {
            FieldDescriptor fmd = fields[i];
            fmd.getPersistentField().set(result, row[i]);
            ++i;
        }
        return result;
    }

    /*
     * Unable to fully structure code
     */
    protected Object buildWithMultiArgsConstructor(ClassDescriptor cld, Object[] row, Constructor multiArgsConstructor) throws SQLException, InstantiationException, IllegalAccessException, InvocationTargetException, PersistenceBrokerException {
        try {
            result = multiArgsConstructor.newInstance(row);
            return result;
        }
        catch (Throwable t) {
            buf = new StringBuffer();
            i = 0;
            ** while (i < row.length)
        }
lbl-1000:
        // 1 sources

        {
            buf.append(row[i] + ", \n");
            ++i;
            continue;
        }
lbl12:
        // 1 sources

        clazzes = multiArgsConstructor.getParameterTypes();
        i = 0;
        while (i < clazzes.length) {
            buf.append(clazzes[i].getName() + ", \n");
            ++i;
        }
        LoggerFactory.getDefaultLogger().error(buf.toString());
        throw new PersistenceBrokerException(t);
    }

    public void readPkValuesFrom(ResultSet rs, ClassDescriptor cld, Object[] row) {
        try {
            ConversionStrategy conversion = cld.getConversionStrategy();
            FieldDescriptor[] pkFields = cld.getPkFields();
            int i = 0;
            while (i < pkFields.length) {
                FieldDescriptor fmd = pkFields[i];
                Object val = JdbcAccess.getObjectFromColumn(rs, fmd);
                row[i] = conversion.sqlToJava(val, fmd);
                ++i;
            }
        }
        catch (Throwable t) {
            throw new PersistenceBrokerException(t);
        }
    }
}

