/*
 * Decompiled with CFR 0.152.
 */
package ojb.broker.accesslayer;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import ojb.broker.PersistenceBrokerException;
import ojb.broker.accesslayer.JdbcAccess;
import ojb.broker.accesslayer.RsIterator;
import ojb.broker.metadata.ClassDescriptor;
import ojb.broker.query.Query;
import ojb.broker.singlevm.PersistenceBrokerImpl;

public class ReportQueryRsIterator
extends RsIterator {
    private ResultSetMetaData rsMetaData;
    private int columnCount;

    public ReportQueryRsIterator(Query query, ClassDescriptor mif, PersistenceBrokerImpl broker) {
        super(query, mif, broker);
        try {
            this.rsMetaData = this.m_rs.getMetaData();
            this.columnCount = this.rsMetaData.getColumnCount();
        }
        catch (SQLException e) {
            throw new PersistenceBrokerException(e);
        }
    }

    protected Object getObjectFromResultSet() throws PersistenceBrokerException {
        Object[] result = new Object[this.columnCount];
        int i = 0;
        while (i < this.columnCount) {
            try {
                Object item;
                int jdbcType = this.rsMetaData.getColumnType(i + 1);
                result[i] = item = JdbcAccess.getObjectFromColumn(this.m_rs, jdbcType, i + 1);
            }
            catch (SQLException e) {
                throw new PersistenceBrokerException(e);
            }
            ++i;
        }
        return result;
    }
}

