/*
 * Decompiled with CFR 0.152.
 */
package ojb.broker.accesslayer;

import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.AbstractCollection;
import java.util.ArrayList;
import ojb.broker.Identity;
import ojb.broker.PersistenceBroker;
import ojb.broker.PersistenceBrokerException;
import ojb.broker.PersistenceBrokerFactory;
import ojb.broker.accesslayer.MaterializationListener;
import ojb.broker.util.LoggerFactory;

public class IndirectionHandler
implements InvocationHandler,
Serializable {
    private transient PersistenceBroker broker = null;
    private Object realSubject = null;
    private Identity id = null;
    private ArrayList listeners = new ArrayList();

    public synchronized void addListener(MaterializationListener l) {
        this.listeners.add(l);
    }

    public synchronized void removeListener(MaterializationListener l) {
        ((AbstractCollection)this.listeners).remove(l);
    }

    protected void beforeMaterialization() {
        int i = this.listeners.size() - 1;
        while (i >= 0) {
            MaterializationListener l = (MaterializationListener)this.listeners.get(i);
            l.beforeMaterialization(this, this.id);
            --i;
        }
    }

    protected void afterMaterialization() {
        int i = this.listeners.size() - 1;
        while (i >= 0) {
            MaterializationListener l = (MaterializationListener)this.listeners.get(i);
            l.afterMaterialization(this, this.realSubject);
            --i;
        }
    }

    public Identity getIdentity() {
        return this.id;
    }

    protected PersistenceBroker getBroker() throws PersistenceBrokerException {
        if (this.broker == null) {
            try {
                this.broker = PersistenceBrokerFactory.createPersistenceBroker();
            }
            catch (Throwable t) {
                LoggerFactory.getDefaultLogger().error(t);
                throw new PersistenceBrokerException(t);
            }
        }
        return this.broker;
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        try {
            Object subject = this.getRealSubject();
            Method m = subject.getClass().getMethod(method.getName(), method.getParameterTypes());
            return m.invoke(subject, args);
        }
        catch (Throwable t) {
            LoggerFactory.getDefaultLogger().error(t);
            throw t;
        }
    }

    public IndirectionHandler(Identity oid) {
        this.id = oid;
        this.broker = PersistenceBrokerFactory.createPersistenceBroker();
    }

    public Object getRealSubject() throws PersistenceBrokerException {
        if (this.realSubject == null) {
            this.materializeSubject();
        }
        return this.realSubject;
    }

    private synchronized void materializeSubject() throws PersistenceBrokerException {
        this.beforeMaterialization();
        this.realSubject = this.getBroker().getObjectByIdentity(this.id);
        if (this.realSubject == null) {
            LoggerFactory.getDefaultLogger().warn("OJB broker could not materialize " + this.id.toString());
        }
        this.afterMaterialization();
    }

    public boolean alreadyMaterialized() {
        return this.realSubject != null;
    }
}

