/*
 * Decompiled with CFR 0.152.
 */
package ojb.broker.accesslayer;

import java.sql.Connection;
import java.sql.DriverManager;
import javax.naming.InitialContext;
import javax.sql.DataSource;
import ojb.broker.PersistenceBrokerException;
import ojb.broker.accesslayer.ConnectionFactory;
import ojb.broker.metadata.JdbcConnectionDescriptor;
import ojb.broker.platforms.PlatformFactory;
import ojb.broker.singlevm.PersistenceBrokerImpl;
import ojb.broker.util.LoggerFactory;

public class ConnectionFactoryDefaultImpl
implements ConnectionFactory {
    public Connection newConnection(JdbcConnectionDescriptor jcd, PersistenceBrokerImpl broker) throws PersistenceBrokerException {
        String user = jcd.getUserName();
        String pass = jcd.getPassWord();
        if (user == null) {
            user = "";
        }
        if (pass == null) {
            pass = "";
        }
        Connection conn = null;
        if (jcd.getDatasourceName() != null) {
            try {
                InitialContext ic = new InitialContext();
                DataSource ds = (DataSource)ic.lookup(jcd.getDatasourceName());
                if (user == "") {
                    conn = ds.getConnection();
                }
                conn = ds.getConnection(user, pass);
            }
            catch (Throwable t) {
                LoggerFactory.getDefaultLogger().error(t);
                throw new PersistenceBrokerException(t);
            }
        } else {
            try {
                String driver = jcd.getDriver();
                String url = jcd.getProtocol() + ":" + jcd.getSubProtocol() + ":" + jcd.getDbAlias();
                Class.forName(driver, true, Thread.currentThread().getContextClassLoader());
                conn = DriverManager.getConnection(url, user, pass);
            }
            catch (Throwable t) {
                LoggerFactory.getDefaultLogger().error(t);
                throw new PersistenceBrokerException(t);
            }
        }
        try {
            conn.setAutoCommit(!broker.isInTransaction());
            PlatformFactory.getPlatformFor(jcd).initializeJdbcConnection(conn);
            return conn;
        }
        catch (Throwable t) {
            LoggerFactory.getDefaultLogger().error(t);
            throw new PersistenceBrokerException(t);
        }
    }
}

