/*
 * Decompiled with CFR 0.152.
 */
package ojb.broker;

import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Vector;
import javax.xml.parsers.ParserConfigurationException;
import ojb.broker.PersistenceBroker;
import ojb.broker.PersistenceBrokerException;
import ojb.broker.metadata.DescriptorRepository;
import ojb.broker.server.PersistenceBrokerClient;
import ojb.broker.server.ServerPool;
import ojb.broker.singlevm.PersistenceBrokerImpl;
import ojb.broker.util.Logger;
import ojb.broker.util.LoggerFactory;
import ojb.broker.util.PersistenceBrokerFactoryConfiguration;
import org.xml.sax.SAXException;

public class PersistenceBrokerFactory {
    private static DescriptorRepository repository = null;
    private static PersistenceBroker lastServed;
    private static PersistenceBrokerFactoryConfiguration configuration;
    private static Vector brokerPool;
    private static Logger logger;
    static /* synthetic */ Class class$ojb$broker$PersistenceBrokerFactory;

    public static PersistenceBrokerFactoryConfiguration getConfiguration() {
        return configuration;
    }

    private static Logger getLogger() {
        if (logger == null) {
            logger = LoggerFactory.getLogger(class$ojb$broker$PersistenceBrokerFactory == null ? (class$ojb$broker$PersistenceBrokerFactory = PersistenceBrokerFactory.class$("ojb.broker.PersistenceBrokerFactory")) : class$ojb$broker$PersistenceBrokerFactory);
        }
        return logger;
    }

    private static synchronized PersistenceBrokerImpl getPooledInstance() {
        if (repository == null) {
            throw new PersistenceBrokerException("don't know which repository to use");
        }
        if (brokerPool.size() == 0) {
            return new PersistenceBrokerImpl(repository);
        }
        PersistenceBrokerImpl pooledInstance = (PersistenceBrokerImpl)brokerPool.remove(0);
        PersistenceBrokerFactory.getLogger().debug("obtain broker " + pooledInstance);
        return pooledInstance;
    }

    public static synchronized void releaseInstance(PersistenceBroker broker) {
        if (broker != null && broker instanceof PersistenceBrokerImpl) {
            PersistenceBrokerImpl instance = (PersistenceBrokerImpl)broker;
            if (instance.isInTransaction()) {
                instance.abortTransaction();
            }
            brokerPool.add(instance);
            PersistenceBrokerFactory.getLogger().debug("release broker " + broker + ", pool size: " + brokerPool.size());
        }
    }

    public static PersistenceBroker createPersistenceBroker(String repositoryFile) throws MalformedURLException, ParserConfigurationException, SAXException, IOException {
        if (configuration.isServerUsed()) {
            if ("true".equals(System.getProperty("OJB.servermode"))) {
                if (repository == null) {
                    repository = DescriptorRepository.getInstance(repositoryFile);
                }
                lastServed = new PersistenceBrokerImpl(repository);
                return lastServed;
            }
            ServerPool pool = new ServerPool(configuration.getServers());
            lastServed = new PersistenceBrokerClient(pool);
            return lastServed;
        }
        if (repository == null) {
            repository = DescriptorRepository.getInstance(repositoryFile);
        }
        return PersistenceBrokerFactory.getPooledInstance();
    }

    public static PersistenceBroker createPersistenceBroker() {
        if (lastServed != null) {
            return lastServed;
        }
        try {
            return PersistenceBrokerFactory.createPersistenceBroker(configuration.getRepositoryFilename());
        }
        catch (Exception e) {
            LoggerFactory.getBootLogger().fatal(e);
            System.exit(1);
            return null;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        configuration = new PersistenceBrokerFactoryConfiguration();
        brokerPool = new Vector();
        logger = null;
    }
}

