/*
 * Decompiled with CFR 0.152.
 */
package com.develop.jcfe.attribute;

import com.develop.jcfe.attribute.Attribute;
import com.develop.jcfe.attribute.LocalVariableTableEntry;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Vector;

public class LocalVariableTableAttribute
extends Attribute {
    private short local_variable_table_length;
    private Vector local_variable_table = new Vector();

    public LocalVariableTableAttribute(DataInputStream dis, short name_index, int attribute_length) throws IOException {
        super("LocalVariableTable", name_index);
        this.local_variable_table_length = dis.readShort();
        short loop = 0;
        while (loop < this.local_variable_table_length) {
            this.local_variable_table.addElement(new LocalVariableTableEntry(dis));
            loop = (short)(loop + 1);
        }
    }

    public int getLength() {
        int length = 2;
        int n = 0;
        while (n < this.local_variable_table_length) {
            length += this.getTableEntry(n).getLength();
            ++n;
        }
        return length;
    }

    public LocalVariableTableEntry getTableEntry(int n) {
        return (LocalVariableTableEntry)this.local_variable_table.elementAt(n);
    }

    public void writeToStream(DataOutputStream ds) throws IOException {
        super.writeToStream(ds);
        ds.writeShort(this.local_variable_table_length);
        short s = 0;
        while (s < this.local_variable_table_length) {
            this.getTableEntry(s).writeToStream(ds);
            s = (short)(s + 1);
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("Local variable table: ");
        int n = 0;
        while (n < this.local_variable_table_length) {
            sb.append("\n\t").append(this.getTableEntry(n).toString());
            ++n;
        }
        return sb.toString();
    }
}

