/*
 * Decompiled with CFR 0.152.
 */
package com.develop.jcfe.attribute;

import com.develop.jcfe.attribute.Attribute;
import com.develop.jcfe.attribute.LineNumberTableEntry;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Vector;

public class LineNumberTableAttribute
extends Attribute {
    private short line_number_table_length;
    private Vector line_number_table = new Vector();

    public LineNumberTableAttribute(DataInputStream dis, short name_index, int attribute_length) throws IOException {
        super("LineNumberTable", name_index);
        this.line_number_table_length = dis.readShort();
        short loop = 0;
        while (loop < this.line_number_table_length) {
            this.line_number_table.addElement(new LineNumberTableEntry(dis));
            loop = (short)(loop + 1);
        }
    }

    public int getLength() {
        int length = 2;
        short n = 0;
        while (n < this.line_number_table_length) {
            length += this.getTableEntry(n).getLength();
            n = (short)(n + 1);
        }
        return length;
    }

    public LineNumberTableEntry getTableEntry(short s) {
        return (LineNumberTableEntry)this.line_number_table.elementAt(s);
    }

    public void writeToStream(DataOutputStream ds) throws IOException {
        super.writeToStream(ds);
        ds.writeShort(this.line_number_table_length);
        short s = 0;
        while (s < this.line_number_table_length) {
            this.getTableEntry(s).writeToStream(ds);
            s = (short)(s + 1);
        }
    }
}

