/*
 * Decompiled with CFR 0.152.
 */
package com.develop.jcfe.attribute;

import com.develop.jcfe.attribute.Attribute;
import com.develop.jcfe.cpool.ConstantPool;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Vector;

public class ExceptionsAttribute
extends Attribute {
    private short number_of_exceptions;
    private Vector exception_index_table = new Vector();

    public short getNumberOfExceptions() {
        return this.number_of_exceptions;
    }

    public ExceptionsAttribute(DataInputStream dis, short name_index, int attribute_length) throws IOException {
        super("Exceptions", name_index);
        this.number_of_exceptions = dis.readShort();
        short loop = 0;
        while (loop < this.number_of_exceptions) {
            this.exception_index_table.addElement(new Short(dis.readShort()));
            loop = (short)(loop + 1);
        }
    }

    public int getLength() {
        return 2 + 2 * this.number_of_exceptions;
    }

    public ExceptionsAttribute(ConstantPool cp) {
        super("Exceptions", cp.addUtf8("Exceptions"));
    }

    public void addException(short index) {
        this.exception_index_table.addElement(new Short(index));
        this.number_of_exceptions = (short)(this.number_of_exceptions + 1);
    }

    public short getTableEntry(int n) {
        return (Short)this.exception_index_table.elementAt(n);
    }

    public void writeToStream(DataOutputStream ds) throws IOException {
        super.writeToStream(ds);
        ds.writeShort(this.number_of_exceptions);
        short s = 0;
        while (s < this.number_of_exceptions) {
            ds.writeShort(this.getTableEntry(s));
            s = (short)(s + 1);
        }
    }
}

