/*
 * Decompiled with CFR 0.152.
 */
package com.develop.jcfe;

import com.develop.jcfe.JavaType;
import java.util.Vector;

public class MethodType {
    private JavaType[] params = null;
    private JavaType retval = null;

    public int getParamCount() {
        return this.params.length;
    }

    public JavaType getReturnType() {
        return this.retval;
    }

    public JavaType[] getParams() {
        return this.params;
    }

    public Class[] getParamClasses(ClassLoader cl) throws ClassNotFoundException {
        Class[] classes = new Class[this.params.length];
        int n = 0;
        while (n < this.params.length) {
            classes[n] = this.params[n].toClass(cl);
            ++n;
        }
        return classes;
    }

    public int getRetvalSize() {
        return this.retval.getSize();
    }

    public int getParamsSize() {
        int size = 0;
        int n = 0;
        while (n < this.params.length) {
            size += this.params[n].getSize();
            ++n;
        }
        return size;
    }

    public MethodType(String desc) {
        Vector<JavaType> paramVec = new Vector<JavaType>();
        if (desc.charAt(0) != '(') {
            throw new Error("not a valid method descriptor");
        }
        int end = 1;
        int n = 1;
        while (n < desc.length()) {
            end = n;
            while (desc.charAt(end) == '[') {
                ++end;
            }
            String str = desc.substring(n, end + 1);
            if (str.equals(")")) break;
            JavaType jt = new JavaType(str);
            if (jt.hasPrimitive()) {
                paramVec.addElement(jt);
            } else {
                end = desc.indexOf(59, n);
                paramVec.addElement(new JavaType(desc.substring(n, end + 1)));
            }
            n = end + 1;
        }
        this.retval = end < desc.length() ? new JavaType(desc.substring(end + 1, desc.length())) : new JavaType("V");
        this.params = new JavaType[paramVec.size()];
        paramVec.toArray(this.params);
    }
}

