/*
 * Decompiled with CFR 0.152.
 */
package com.develop.jcfe;

import com.develop.jcfe.JavaType;
import com.develop.jcfe.attribute.Attribute;
import com.develop.jcfe.attribute.AttributeSet;
import com.develop.jcfe.cpool.ConstantPool;
import com.develop.jcfe.cpool.PoolEntry;
import com.develop.jcfe.field_info;
import com.develop.jcfe.method_info;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;

public class ClassFile {
    public int magic = -889275714;
    public short minor_version = (short)3;
    public short major_version = (short)45;
    private short access_flags;
    public short this_class = 0;
    public short super_class = 0;
    private final ConstantPool cp = new ConstantPool();
    private final HashMap interfaces = new HashMap();
    private final HashMap fields = new HashMap();
    private final HashMap methods = new HashMap();
    private final AttributeSet attset = new AttributeSet(this.cp);
    static /* synthetic */ Class class$com$develop$jcfe$ClassFile;

    public ConstantPool getConstantPool() {
        return this.cp;
    }

    public Iterator getFieldIter() {
        return this.fields.keySet().iterator();
    }

    public Iterator getMethodIter() {
        return this.methods.keySet().iterator();
    }

    public method_info getMethod(String sig) {
        return (method_info)this.methods.get(sig);
    }

    public HashMap getMethods() {
        return this.methods;
    }

    public int getConstantPoolSize() {
        return this.cp.size();
    }

    short getAccessFlags() {
        return this.access_flags;
    }

    public void setAccessFlags(short flags) {
        this.access_flags = flags;
    }

    short getInterfacesCount() {
        return (short)this.interfaces.size();
    }

    short getFieldsCount() {
        return (short)this.fields.size();
    }

    short getMethodsCount() {
        return (short)this.methods.size();
    }

    public short getAttributesCount() {
        return (short)this.attset.size();
    }

    public void addAttribute(Attribute att) {
        this.attset.add(att);
    }

    public Attribute getAttribute(int index) {
        return this.attset.get(index);
    }

    public Attribute[] getAttributes() {
        return this.attset.getAttributes();
    }

    public Attribute getAttribute(String name) {
        return this.attset.getAttribute(name);
    }

    public void addImplementedInterface(JavaType itf) {
        short sClassIndex = this.cp.addClass(itf);
        this.interfaces.put(itf.getDottedName(), new Short(sClassIndex));
    }

    public void addField(short access_flags, String name, String desc) {
        short nameIndex = this.cp.addUtf8(name);
        short descIndex = this.cp.addUtf8(desc);
        this.fields.put(name, new field_info(this.cp, access_flags, nameIndex, descIndex));
    }

    public void addField(field_info fi) {
        this.fields.put(this.cp.getUtf8(fi.getNameIndex()), fi);
    }

    public void setThisClass(String name) {
        this.this_class = this.cp.addClass(new JavaType(name));
    }

    public String getThisClassString() {
        return this.cp.getClassString(this.this_class);
    }

    public void setSuperclass(String name) {
        this.super_class = this.cp.addClass(new JavaType(name));
    }

    public method_info addMethod(short access_flags, String name, String descriptor) {
        short name_index = this.cp.addUtf8(name);
        short descriptor_index = this.cp.addUtf8(descriptor);
        method_info mi = new method_info(this.cp, access_flags, name_index, descriptor_index);
        this.methods.put(name + descriptor, mi);
        return mi;
    }

    public void addMethod(method_info mi) {
        this.methods.put(this.cp.getUtf8(mi.getNameIndex()) + this.cp.getUtf8(mi.getDescriptorIndex()).toString(), mi);
    }

    public void writeToStream(DataOutputStream ds) throws IOException {
        ds.writeInt(this.magic);
        ds.writeShort(this.minor_version);
        ds.writeShort(this.major_version);
        ds.writeShort(this.cp.size());
        int n = 1;
        while (n < this.cp.size()) {
            this.cp.getConstant(n).writeToStream(ds);
            ++n;
        }
        ds.writeShort(this.access_flags);
        ds.writeShort(this.this_class);
        ds.writeShort(this.super_class);
        ds.writeShort(this.interfaces.size());
        Iterator iter = null;
        iter = this.interfaces.values().iterator();
        while (iter.hasNext()) {
            ds.writeShort(((Short)iter.next()).shortValue());
        }
        ds.writeShort(this.fields.size());
        iter = this.fields.values().iterator();
        while (iter.hasNext()) {
            ((field_info)iter.next()).writeToStream(ds);
        }
        ds.writeShort(this.methods.size());
        iter = this.methods.values().iterator();
        while (iter.hasNext()) {
            ((method_info)iter.next()).writeToStream(ds);
        }
        ds.writeShort(this.attset.size());
        iter = this.attset.iterator();
        while (iter.hasNext()) {
            ((Attribute)iter.next()).writeToStream(ds);
        }
    }

    public ClassFile() {
    }

    public static ClassFile readFromFile(String fileName) throws IOException {
        File f = new File(fileName);
        FileInputStream fis = new FileInputStream(fileName);
        byte[] buf = new byte[(int)f.length()];
        if (f.length() != (long)fis.read(buf)) {
            throw new EOFException("Could not read " + f.length() + " bytes from file " + fileName);
        }
        ClassFile cf = new ClassFile(buf);
        return cf;
    }

    public static ClassFile loadFromVM(Class cls) throws IOException, ClassNotFoundException {
        ClassLoader cl = cls.getClassLoader();
        return ClassFile.loadFromVM(cls.getName(), cl);
    }

    public static ClassFile loadFromVM(String name) throws IOException, ClassNotFoundException {
        ClassLoader cl = (class$com$develop$jcfe$ClassFile == null ? (class$com$develop$jcfe$ClassFile = ClassFile.class$("com.develop.jcfe.ClassFile")) : class$com$develop$jcfe$ClassFile).getClass().getClassLoader();
        return ClassFile.loadFromVM(name, cl);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ClassFile loadFromVM(String name, ClassLoader cl) throws IOException, ClassNotFoundException {
        IOException ioe22;
        ClassFile classFile;
        ByteArrayOutputStream baos;
        block12: {
            if (name == null) {
                throw new IllegalArgumentException();
            }
            String resName = name.replace('.', '/') + ".class";
            InputStream is = null;
            baos = null;
            try {
                is = cl == null ? ClassLoader.getSystemResourceAsStream(resName) : cl.getResourceAsStream(resName);
                if (is == null) {
                    throw new ClassNotFoundException("Could not find class bytes for " + resName);
                }
                baos = new ByteArrayOutputStream();
                int ch = 0;
                while (-1 != (ch = is.read())) {
                    baos.write(ch);
                }
                is.close();
                byte[] bytes = baos.toByteArray();
                classFile = new ClassFile(bytes);
                Object var9_8 = null;
                if (is == null) break block12;
            }
            catch (Throwable throwable) {
                IOException ioe22;
                Object var9_9 = null;
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException ioe22) {
                        // empty catch block
                    }
                }
                if (baos == null) throw throwable;
                try {
                    baos.close();
                    throw throwable;
                }
                catch (IOException ioe22) {}
                throw throwable;
            }
            try {
                is.close();
            }
            catch (IOException ioe22) {
                // empty catch block
            }
        }
        if (baos == null) return classFile;
        try {
            baos.close();
            return classFile;
        }
        catch (IOException ioe22) {
            // empty catch block
        }
        return classFile;
    }

    public ClassFile(byte[] buf) throws IOException {
        ByteArrayInputStream bais = new ByteArrayInputStream(buf);
        DataInputStream dis = new DataInputStream(bais);
        this.magic = dis.readInt();
        this.minor_version = dis.readShort();
        this.major_version = dis.readShort();
        short totalPoolSize = dis.readShort();
        while (this.cp.size() < totalPoolSize) {
            this.cp.addConstant(PoolEntry.readCPInfo(dis, (short)this.cp.size()));
        }
        this.access_flags = dis.readShort();
        this.this_class = dis.readShort();
        this.super_class = dis.readShort();
        short interfaces_count = dis.readShort();
        short loop = 0;
        while (loop < interfaces_count) {
            short temp = dis.readShort();
            this.interfaces.put(this.cp.getClass(temp), new Short(temp));
            loop = (short)(loop + 1);
        }
        short fields_count = dis.readShort();
        loop = 0;
        while (loop < fields_count) {
            field_info fi = new field_info(this.cp, dis, loop);
            this.addField(fi);
            loop = (short)(loop + 1);
        }
        short methods_count = dis.readShort();
        loop = 0;
        while (loop < methods_count) {
            method_info mi = new method_info(this, dis, loop);
            this.addMethod(mi);
            loop = (short)(loop + 1);
        }
        short attributes_count = dis.readShort();
        loop = 0;
        while (loop < attributes_count) {
            this.attset.add(Attribute.read(this.cp, dis));
            loop = (short)(loop + 1);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

