/*
 * Decompiled with CFR 0.152.
 */
package com.develop.delegator;

import com.develop.java.lang.reflect.InvocationHandler;
import com.develop.java.lang.reflect.Proxy;
import java.io.InvalidClassException;
import java.io.ObjectStreamException;
import java.io.Serializable;

class SerializedProxy
implements Serializable {
    private String[] itfNames;
    private InvocationHandler handler;

    SerializedProxy(Class[] itfClasses, InvocationHandler h) {
        int count = itfClasses.length;
        this.itfNames = new String[count];
        int n = 0;
        while (n < count) {
            this.itfNames[n] = itfClasses[n].getName();
            ++n;
        }
        this.handler = h;
    }

    Object readResolve() throws ObjectStreamException {
        int count = this.itfNames.length;
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Class[] itfClasses = new Class[count];
        try {
            int n = 0;
            while (n < count) {
                itfClasses[n] = Class.forName(this.itfNames[n], true, cl);
                ++n;
            }
            return Proxy.newProxyInstance(cl, itfClasses, this.handler);
        }
        catch (Throwable t) {
            throw new InvalidClassException(t.getMessage());
        }
    }
}

