/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import org.hsqldb.DatabaseRowOutputInterface;
import org.hsqldb.Table;
import org.hsqldb.Trace;

abstract class DatabaseRowOutput
extends DataOutputStream
implements DatabaseRowOutputInterface {
    protected boolean skipSystemId = false;

    public DatabaseRowOutput(OutputStream outputStream) throws IOException {
        super(outputStream);
    }

    public abstract void writePos(int var1) throws IOException;

    public abstract void writeSize(int var1) throws IOException;

    public abstract void writeType(int var1) throws IOException;

    public abstract void writeIntData(int var1) throws IOException;

    public abstract void writeString(String var1) throws IOException;

    protected abstract void writeFieldType(int var1) throws IOException;

    protected abstract void writeNull(int var1) throws IOException;

    protected abstract void writeChar(String var1, int var2) throws IOException;

    protected abstract void writeSmallint(Number var1) throws IOException, SQLException;

    protected abstract void writeInteger(Number var1) throws IOException, SQLException;

    protected abstract void writeBigint(Number var1) throws IOException, SQLException;

    protected abstract void writeReal(Double var1, int var2) throws IOException, SQLException;

    protected abstract void writeDecimal(BigDecimal var1) throws IOException, SQLException;

    protected abstract void writeBit(Boolean var1) throws IOException, SQLException;

    protected abstract void writeDate(Date var1) throws IOException, SQLException;

    protected abstract void writeTime(Time var1) throws IOException, SQLException;

    protected abstract void writeTimestamp(Timestamp var1) throws IOException, SQLException;

    protected abstract void writeOther(Object var1) throws IOException, SQLException;

    protected abstract void writeBinary(byte[] var1, int var2) throws IOException, SQLException;

    public void writeData(Object[] objectArray, Table table) throws IOException, SQLException {
        int[] nArray = table.getColumnTypes();
        int n = nArray.length;
        if (this.skipSystemId) {
            --n;
        }
        this.writeData(n, nArray, objectArray);
    }

    public void writeData(int n, int[] nArray, Object[] objectArray) throws IOException, SQLException {
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            int n3 = nArray[n2];
            if (object == null) {
                this.writeNull(n3);
            } else {
                this.writeFieldType(n3);
                switch (n3) {
                    case -1: 
                    case 1: 
                    case 12: 
                    case 100: {
                        this.writeChar((String)object, n3);
                        break;
                    }
                    case -6: 
                    case 5: {
                        this.writeSmallint((Number)object);
                        break;
                    }
                    case 4: {
                        this.writeInteger((Number)object);
                        break;
                    }
                    case -5: {
                        this.writeBigint((Number)object);
                        break;
                    }
                    case 6: 
                    case 7: 
                    case 8: {
                        this.writeReal((Double)object, n3);
                        break;
                    }
                    case 2: 
                    case 3: {
                        this.writeDecimal((BigDecimal)object);
                        break;
                    }
                    case -7: {
                        this.writeBit((Boolean)object);
                        break;
                    }
                    case 91: {
                        this.writeDate((Date)object);
                        break;
                    }
                    case 92: {
                        this.writeTime((Time)object);
                        break;
                    }
                    case 93: {
                        this.writeTimestamp((Timestamp)object);
                        break;
                    }
                    case 1111: {
                        this.writeOther(object);
                        break;
                    }
                    case -4: 
                    case -3: 
                    case -2: {
                        this.writeBinary((byte[])object, n3);
                        break;
                    }
                    default: {
                        throw Trace.error(20, n3);
                    }
                }
            }
            ++n2;
        }
    }

    public abstract byte[] toByteArray() throws IOException;
}

