/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.velocity;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationConverter;
import org.apache.fulcrum.InitializationException;
import org.apache.fulcrum.ServiceException;
import org.apache.fulcrum.template.BaseTemplateEngineService;
import org.apache.fulcrum.template.TemplateContext;
import org.apache.fulcrum.velocity.ContextAdapter;
import org.apache.fulcrum.velocity.VelocityService;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.app.event.EventCartridge;
import org.apache.velocity.app.event.EventHandler;
import org.apache.velocity.app.event.MethodExceptionEventHandler;
import org.apache.velocity.app.event.NullSetEventHandler;
import org.apache.velocity.app.event.ReferenceInsertionEventHandler;
import org.apache.velocity.context.Context;
import org.apache.velocity.context.InternalEventContext;
import org.apache.velocity.exception.MethodInvocationException;

public class TurbineVelocityService
extends BaseTemplateEngineService
implements VelocityService {
    private static final String RESOURCE_LOADER_PATH = ".resource.loader.path";
    private static final String DEFAULT_CHAR_SET = "ISO-8859-1";
    private static final String JAR_PREFIX = "jar:";
    private static final String ABSOLUTE_PREFIX = "file://";
    private EventCartridge eventCartridge;
    private boolean eventCartridgeEnabled = true;
    private VelocityEngine velocityEngine = new VelocityEngine();

    public void init() throws InitializationException {
        try {
            this.initVelocity();
            this.initEventCartridges();
            this.registerConfiguration("vm");
            this.setInit(true);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new InitializationException("Failed to initialize TurbineVelocityService", e);
        }
    }

    public String handleRequest(TemplateContext context, String template) throws ServiceException {
        return this.handleRequest((Context)new ContextAdapter(context), template);
    }

    public String handleRequest(Context context, String filename) throws ServiceException {
        return this.handleRequest(context, filename, (String)null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public String handleRequest(Context context, String filename, String charset, String encoding) throws ServiceException {
        String results;
        block11: {
            results = null;
            ByteArrayOutputStream bytes = null;
            bytes = new ByteArrayOutputStream();
            charset = this.decodeRequest(context, filename, bytes, charset, encoding);
            results = bytes.toString(charset);
            Object var9_7 = null;
            try {
                if (bytes != null) {
                    bytes.close();
                }
                break block11;
            }
            catch (IOException ignored) {}
            break block11;
            {
                catch (Exception e) {
                    this.renderingError(filename, e);
                    Object var9_8 = null;
                    try {
                        if (bytes != null) {
                            bytes.close();
                        }
                        break block11;
                    }
                    catch (IOException ignored) {}
                }
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                try {
                    if (bytes != null) {
                        bytes.close();
                    }
                }
                catch (IOException ignored) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return results;
    }

    public void handleRequest(TemplateContext context, String template, OutputStream outputStream) throws ServiceException {
        this.handleRequest((Context)new ContextAdapter(context), template, outputStream);
    }

    public void handleRequest(Context context, String filename, OutputStream output) throws ServiceException {
        this.handleRequest(context, filename, output, null, null);
    }

    public void handleRequest(Context context, String filename, OutputStream output, String charset, String encoding) throws ServiceException {
        this.decodeRequest(context, filename, output, charset, encoding);
    }

    public void handleRequest(TemplateContext context, String template, Writer writer) throws ServiceException {
        this.handleRequest((Context)new ContextAdapter(context), template, writer);
    }

    public void handleRequest(Context context, String filename, Writer writer) throws ServiceException {
        this.handleRequest(context, filename, writer, null);
    }

    public void handleRequest(Context context, String filename, Writer writer, String encoding) throws ServiceException {
        try {
            Object eventContext = context instanceof InternalEventContext ? context : new VelocityContext(context);
            EventCartridge ec = this.getEventCartridge();
            if (ec != null && this.eventCartridgeEnabled) {
                ec.attachToContext(eventContext);
            }
            if (encoding != null) {
                this.velocityEngine.mergeTemplate(filename, encoding, eventContext, writer);
            } else {
                this.velocityEngine.mergeTemplate(filename, eventContext, writer);
            }
        }
        catch (Exception e) {
            this.renderingError(filename, e);
        }
    }

    public void setEventCartridgeEnabled(boolean value) {
        this.eventCartridgeEnabled = value;
    }

    public EventCartridge getEventCartridge() {
        return this.eventCartridge;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String decodeRequest(Context context, String filename, OutputStream output, String charset, String encoding) throws ServiceException {
        if (charset == null) {
            charset = DEFAULT_CHAR_SET;
        }
        OutputStreamWriter writer = null;
        try {
            try {
                writer = new OutputStreamWriter(output, charset);
            }
            catch (Exception e) {
                this.renderingError(filename, e);
            }
            this.handleRequest(context, filename, writer, encoding);
            Object var9_8 = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            try {
                if (writer != null) {
                    writer.flush();
                }
            }
            catch (Exception ignored) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            if (writer != null) {
                writer.flush();
            }
        }
        catch (Exception ignored) {}
        return charset;
    }

    private final void renderingError(String filename, Throwable e) throws ServiceException {
        String err = "Error rendering Velocity template: " + filename;
        this.getCategory().error((Object)(err + ": " + e.getMessage()));
        if (e instanceof MethodInvocationException) {
            e = ((MethodInvocationException)e).getWrappedThrowable();
        }
        throw new ServiceException(err, e);
    }

    private void initEventCartridges() throws InitializationException {
        this.eventCartridge = new EventCartridge();
        Vector ecconfig = this.getConfiguration().getVector("eventCartridge.classes", null);
        if (ecconfig == null) {
            this.getCategory().info((Object)"No Velocity EventCartridges configured.");
            return;
        }
        Object obj = null;
        String className = null;
        Enumeration e = ecconfig.elements();
        while (e.hasMoreElements()) {
            className = (String)e.nextElement();
            try {
                boolean result = false;
                obj = Class.forName(className).newInstance();
                if (obj instanceof ReferenceInsertionEventHandler) {
                    result = this.getEventCartridge().addEventHandler((EventHandler)((ReferenceInsertionEventHandler)obj));
                } else if (obj instanceof NullSetEventHandler) {
                    result = this.getEventCartridge().addEventHandler((EventHandler)((NullSetEventHandler)obj));
                } else if (obj instanceof MethodExceptionEventHandler) {
                    result = this.getEventCartridge().addEventHandler((EventHandler)((MethodExceptionEventHandler)obj));
                }
                this.getCategory().info((Object)("Added EventCartridge: " + obj.getClass().getName() + " : " + result));
            }
            catch (Exception h) {
                throw new InitializationException("Could not initialize EventCartridge: " + className, h);
            }
        }
    }

    private void initVelocity() throws InitializationException {
        String key;
        String path = this.getRealPath(this.getConfiguration().getString("runtime.log", null));
        if (path == null || path.length() <= 0) {
            String msg = "VelocityService runtime log file is misconfigured: '" + path + "' is not a valid log file";
            throw new Error(msg);
        }
        this.getConfiguration().setProperty("runtime.log", (Object)path);
        Vector<String> keys = new Vector<String>();
        Iterator i = this.getConfiguration().getKeys();
        while (i.hasNext()) {
            key = (String)i.next();
            if (!key.endsWith(RESOURCE_LOADER_PATH)) continue;
            keys.add(key);
        }
        Iterator i2 = keys.iterator();
        while (i2.hasNext()) {
            key = (String)i2.next();
            Vector paths = this.getConfiguration().getVector(key, null);
            if (paths == null) continue;
            this.velocityEngine.clearProperty(key);
            this.getConfiguration().clearProperty(key);
            Iterator j = paths.iterator();
            while (j.hasNext()) {
                path = (String)j.next();
                if (path.startsWith("jar:file")) {
                    String entry;
                    int ind = path.indexOf("!/");
                    if (ind >= 0) {
                        entry = path.substring(ind);
                        path = path.substring(9, ind);
                    } else {
                        entry = "!/";
                        path = path.substring(9);
                    }
                    path = "jar:file:" + this.getRealPath(path) + entry;
                } else if (path.startsWith(ABSOLUTE_PREFIX)) {
                    path = path.substring(ABSOLUTE_PREFIX.length(), path.length());
                } else if (!path.startsWith(JAR_PREFIX)) {
                    path = this.getRealPath(path);
                }
                this.getConfiguration().addProperty(key, (Object)path);
            }
        }
        try {
            this.velocityEngine.setExtendedProperties(ConfigurationConverter.getExtendedProperties((Configuration)this.getConfiguration()));
            this.velocityEngine.init();
        }
        catch (Exception e) {
            throw new InitializationException("Failed to set up TurbineVelocityService", e);
        }
    }

    public boolean templateExists(String template) {
        return this.velocityEngine.templateExists(template);
    }

    static {
        RESOURCE_LOADER_PATH = RESOURCE_LOADER_PATH;
        DEFAULT_CHAR_SET = DEFAULT_CHAR_SET;
        JAR_PREFIX = JAR_PREFIX;
        ABSOLUTE_PREFIX = ABSOLUTE_PREFIX;
    }
}

