/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.util.parser;

import java.beans.IndexedPropertyDescriptor;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.fulcrum.pool.Recyclable;
import org.apache.fulcrum.pool.RecyclableSupport;
import org.apache.fulcrum.util.parser.ValueParser;

public class BaseValueParser
extends RecyclableSupport
implements ValueParser,
Recyclable {
    protected Hashtable parameters = new Hashtable();
    private String characterEncoding = "US-ASCII";
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$math$BigDecimal;
    static /* synthetic */ Class array$Ljava$lang$String;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class array$I;
    static /* synthetic */ Class array$Ljava$lang$Integer;
    static /* synthetic */ Class class$java$util$Date;

    public String convertAndTrim(String value) {
        return this.convertAndTrim(value, "lower");
    }

    public String convertAndTrim(String value, String fold) {
        String tmp = value.trim();
        if ("lower".equals(fold)) {
            tmp = tmp.toLowerCase();
        } else if ("upper".equals(fold)) {
            tmp = tmp.toUpperCase();
        }
        return tmp;
    }

    public BaseValueParser() {
    }

    public BaseValueParser(String characterEncoding) {
        this.recycle(characterEncoding);
    }

    public void recycle() {
        this.recycle("US-ASCII");
    }

    public void recycle(String characterEncoding) {
        this.setCharacterEncoding(characterEncoding);
        if (!this.isDisposed()) {
            super.recycle();
        }
    }

    public void dispose() {
        this.clear();
        super.dispose();
    }

    public void clear() {
        this.parameters.clear();
    }

    public void setCharacterEncoding(String s) {
        this.characterEncoding = s;
    }

    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    public void add(String name, double value) {
        this.add(name, Double.toString(value));
    }

    public void add(String name, int value) {
        this.add(name, Integer.toString(value));
    }

    public void add(String name, Integer value) {
        this.add(name, value.toString());
    }

    public void add(String name, long value) {
        this.add(name, Long.toString(value));
    }

    public void add(String name, String value) {
        this.append(name, value);
    }

    public void append(String name, String value) {
        String[] items = this.getStrings(name);
        if (items == null) {
            items = new String[]{value};
            this.parameters.put(this.convert(name), items);
        } else {
            String[] newItems = new String[items.length + 1];
            System.arraycopy(items, 0, newItems, 0, items.length);
            newItems[items.length] = value;
            this.parameters.put(this.convert(name), newItems);
        }
    }

    public Object remove(String name) {
        return this.parameters.remove(this.convert(name));
    }

    public String convert(String value) {
        return this.convertAndTrim(value);
    }

    public boolean containsKey(Object key) {
        return this.parameters.containsKey(this.convert((String)key));
    }

    public Enumeration keys() {
        return this.parameters.keys();
    }

    public Object[] getKeys() {
        return this.parameters.keySet().toArray();
    }

    public boolean getBoolean(String name, boolean defaultValue) {
        boolean value = defaultValue;
        Object object = this.parameters.get(this.convert(name));
        if (object != null) {
            String tmp = this.getString(name);
            if (tmp.equalsIgnoreCase("1") || tmp.equalsIgnoreCase("true") || tmp.equalsIgnoreCase("on")) {
                value = true;
            }
            if (tmp.equalsIgnoreCase("0") || tmp.equalsIgnoreCase("false") || tmp.equalsIgnoreCase("off")) {
                value = false;
            }
        }
        return value;
    }

    public boolean getBoolean(String name) {
        return this.getBoolean(name, false);
    }

    public Boolean getBool(String name, boolean defaultValue) {
        return new Boolean(this.getBoolean(name, defaultValue));
    }

    public Boolean getBool(String name) {
        return new Boolean(this.getBoolean(name, false));
    }

    public double getDouble(String name, double defaultValue) {
        double value = defaultValue;
        try {
            Object object = this.parameters.get(this.convert(name));
            if (object != null) {
                value = Double.valueOf(((String[])object)[0]);
            }
        }
        catch (NumberFormatException exception) {
            // empty catch block
        }
        return value;
    }

    public double getDouble(String name) {
        return this.getDouble(name, 0.0);
    }

    public float getFloat(String name, float defaultValue) {
        float value = defaultValue;
        try {
            Object object = this.parameters.get(this.convert(name));
            if (object != null) {
                value = Float.valueOf(((String[])object)[0]).floatValue();
            }
        }
        catch (NumberFormatException exception) {
            // empty catch block
        }
        return value;
    }

    public float getFloat(String name) {
        return this.getFloat(name, 0.0f);
    }

    public BigDecimal getBigDecimal(String name, BigDecimal defaultValue) {
        BigDecimal value = defaultValue;
        try {
            String temp;
            Object object = this.parameters.get(this.convert(name));
            if (object != null && (temp = ((String[])object)[0]).length() > 0) {
                value = new BigDecimal(((String[])object)[0]);
            }
        }
        catch (NumberFormatException exception) {
            // empty catch block
        }
        return value;
    }

    public BigDecimal getBigDecimal(String name) {
        return this.getBigDecimal(name, new BigDecimal(0.0));
    }

    public BigDecimal[] getBigDecimals(String name) {
        BigDecimal[] value = null;
        String[] object = this.getStrings(this.convert(name));
        if (object != null) {
            String[] temp = object;
            value = new BigDecimal[temp.length];
            int i = 0;
            while (i < temp.length) {
                value[i] = new BigDecimal(temp[i]);
                ++i;
            }
        }
        return value;
    }

    public int getInt(String name, int defaultValue) {
        int value = defaultValue;
        try {
            Object object = this.parameters.get(this.convert(name));
            if (object != null) {
                value = Integer.valueOf(((String[])object)[0]);
            }
        }
        catch (NumberFormatException exception) {
            // empty catch block
        }
        return value;
    }

    public int getInt(String name) {
        return this.getInt(name, 0);
    }

    public Integer getInteger(String name, int defaultValue) {
        return new Integer(this.getInt(name, defaultValue));
    }

    public Integer getInteger(String name, Integer def) {
        return new Integer(this.getInt(name, def));
    }

    public Integer getInteger(String name) {
        return new Integer(this.getInt(name, 0));
    }

    public int[] getInts(String name) {
        int[] value = null;
        String[] object = this.getStrings(this.convert(name));
        if (object != null) {
            String[] temp = object;
            value = new int[temp.length];
            int i = 0;
            while (i < temp.length) {
                value[i] = Integer.parseInt(temp[i]);
                ++i;
            }
        }
        return value;
    }

    public Integer[] getIntegers(String name) {
        Integer[] value = null;
        String[] object = this.getStrings(this.convert(name));
        if (object != null) {
            String[] temp = object;
            value = new Integer[temp.length];
            int i = 0;
            while (i < temp.length) {
                value[i] = Integer.valueOf(temp[i]);
                ++i;
            }
        }
        return value;
    }

    public long getLong(String name, long defaultValue) {
        long value = defaultValue;
        try {
            Object object = this.parameters.get(this.convert(name));
            if (object != null) {
                value = Long.valueOf(((String[])object)[0]);
            }
        }
        catch (NumberFormatException exception) {
            // empty catch block
        }
        return value;
    }

    public long getLong(String name) {
        return this.getLong(name, 0L);
    }

    public long[] getLongs(String name) {
        long[] value = null;
        String[] object = this.getStrings(this.convert(name));
        if (object != null) {
            String[] temp = object;
            value = new long[temp.length];
            int i = 0;
            while (i < temp.length) {
                value[i] = Long.parseLong(temp[i]);
                ++i;
            }
        }
        return value;
    }

    public Long[] getLongObjects(String name) {
        Long[] value = null;
        String[] object = this.getStrings(this.convert(name));
        if (object != null) {
            String[] temp = object;
            value = new Long[temp.length];
            int i = 0;
            while (i < temp.length) {
                value[i] = Long.valueOf(temp[i]);
                ++i;
            }
        }
        return value;
    }

    public byte getByte(String name, byte defaultValue) {
        byte value = defaultValue;
        try {
            Object object = this.parameters.get(this.convert(name));
            if (object != null) {
                value = Byte.valueOf(((String[])object)[0]);
            }
        }
        catch (NumberFormatException exception) {
            // empty catch block
        }
        return value;
    }

    public byte getByte(String name) {
        return this.getByte(name, (byte)0);
    }

    public byte[] getBytes(String name) throws UnsupportedEncodingException {
        String tempStr = this.getString(name);
        if (tempStr != null) {
            return tempStr.getBytes(this.characterEncoding);
        }
        return null;
    }

    public String getString(String name) {
        try {
            String value = null;
            Object object = this.parameters.get(this.convert(name));
            if (object != null) {
                value = ((String[])object)[0];
            }
            if (value == null || value.equals("null")) {
                return null;
            }
            return value;
        }
        catch (ClassCastException e) {
            return null;
        }
    }

    public String get(String name) {
        return this.getString(name);
    }

    public String getString(String name, String defaultValue) {
        String value = this.getString(name);
        if (value == null || value.length() == 0 || value.equals("null")) {
            return defaultValue;
        }
        return value;
    }

    public void setString(String name, String value) {
        if (value != null) {
            this.parameters.put(this.convert(name), new String[]{value});
        }
    }

    public String[] getStrings(String name) {
        String[] value = null;
        Object object = this.parameters.get(this.convert(name));
        if (object != null) {
            value = (String[])object;
        }
        return value;
    }

    public String[] getStrings(String name, String[] defaultValue) {
        String[] value = this.getStrings(name);
        if (value == null || value.length == 0) {
            return defaultValue;
        }
        return value;
    }

    public void setStrings(String name, String[] values) {
        if (values != null) {
            this.parameters.put(this.convert(name), values);
        }
    }

    public Object getObject(String name) {
        try {
            Object value = null;
            Object object = this.parameters.get(this.convert(name));
            if (object != null) {
                value = ((Object[])object)[0];
            }
            return value;
        }
        catch (ClassCastException e) {
            return null;
        }
    }

    public Object[] getObjects(String name) {
        try {
            return (Object[])this.parameters.get(this.convert(name));
        }
        catch (ClassCastException e) {
            return null;
        }
    }

    public Date getDate(String name, DateFormat df, Date defaultValue) {
        Date date = null;
        if (this.containsKey(name)) {
            try {
                df.setLenient(false);
                date = df.parse(this.getString(name));
            }
            catch (ParseException e) {
                date = defaultValue;
            }
        } else {
            date = defaultValue;
        }
        return date;
    }

    public Date getDate(String name, DateFormat df) {
        return this.getDate(name, df, null);
    }

    public Date getDate(String name) {
        DateFormat df = DateFormat.getDateInstance();
        return this.getDate(name, df, null);
    }

    public void setProperties(Object bean) throws Exception {
        Class<?> beanClass = bean.getClass();
        PropertyDescriptor[] props = Introspector.getBeanInfo(beanClass).getPropertyDescriptors();
        int i = 0;
        while (i < props.length) {
            String propname = props[i].getName();
            Method setter = props[i].getWriteMethod();
            if (setter != null && this.containsKey(propname)) {
                this.setProperty(bean, props[i]);
            }
            ++i;
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        Enumeration e = this.parameters.keys();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            try {
                sb.append('{');
                sb.append(name);
                sb.append('=');
                String[] params = this.getStrings(name);
                if (params.length <= 1) {
                    sb.append(params[0]);
                } else {
                    int i = 0;
                    while (i < params.length) {
                        if (i != 0) {
                            sb.append(", ");
                        }
                        sb.append('[').append(params[i]).append(']');
                        ++i;
                    }
                }
                sb.append("}\n");
            }
            catch (Exception ee) {
                try {
                    sb.append('{');
                    sb.append(name);
                    sb.append('=');
                    sb.append("ERROR?");
                    sb.append("}\n");
                }
                catch (Exception eee) {
                    // empty catch block
                }
            }
        }
        return sb.toString();
    }

    protected void setProperty(Object bean, PropertyDescriptor prop) throws Exception {
        if (prop instanceof IndexedPropertyDescriptor) {
            throw new Exception(prop.getName() + " is an indexed property (not supported)");
        }
        Method setter = prop.getWriteMethod();
        if (setter == null) {
            throw new Exception(prop.getName() + " is a read only property");
        }
        Class<?> propclass = prop.getPropertyType();
        Object[] args = new Object[]{null};
        if (propclass == (class$java$lang$String == null ? (class$java$lang$String = BaseValueParser.class$("java.lang.String")) : class$java$lang$String)) {
            args[0] = this.getString(prop.getName());
        } else if (propclass == (class$java$lang$Integer == null ? (class$java$lang$Integer = BaseValueParser.class$("java.lang.Integer")) : class$java$lang$Integer) || propclass == Integer.TYPE) {
            args[0] = this.getInteger(prop.getName());
        } else if (propclass == (class$java$lang$Long == null ? (class$java$lang$Long = BaseValueParser.class$("java.lang.Long")) : class$java$lang$Long) || propclass == Long.TYPE) {
            args[0] = new Long(this.getLong(prop.getName()));
        } else if (propclass == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = BaseValueParser.class$("java.lang.Boolean")) : class$java$lang$Boolean) || propclass == Boolean.TYPE) {
            args[0] = this.getBool(prop.getName());
        } else if (propclass == (class$java$lang$Double == null ? (class$java$lang$Double = BaseValueParser.class$("java.lang.Double")) : class$java$lang$Double) || propclass == Double.TYPE) {
            args[0] = new Double(this.getDouble(prop.getName()));
        } else if (propclass == (class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = BaseValueParser.class$("java.math.BigDecimal")) : class$java$math$BigDecimal)) {
            args[0] = this.getBigDecimal(prop.getName());
        } else if (propclass == (array$Ljava$lang$String == null ? (array$Ljava$lang$String = BaseValueParser.class$("[Ljava.lang.String;")) : array$Ljava$lang$String)) {
            args[0] = this.getStrings(prop.getName());
        } else if (propclass == (class$java$lang$Object == null ? (class$java$lang$Object = BaseValueParser.class$("java.lang.Object")) : class$java$lang$Object)) {
            args[0] = this.getObject(prop.getName());
        } else if (propclass == (array$I == null ? (array$I = BaseValueParser.class$("[I")) : array$I)) {
            args[0] = this.getInts(prop.getName());
        } else if (propclass == (array$Ljava$lang$Integer == null ? (array$Ljava$lang$Integer = BaseValueParser.class$("[Ljava.lang.Integer;")) : array$Ljava$lang$Integer)) {
            args[0] = this.getIntegers(prop.getName());
        } else if (propclass == (class$java$util$Date == null ? (class$java$util$Date = BaseValueParser.class$("java.util.Date")) : class$java$util$Date)) {
            args[0] = this.getDate(prop.getName());
        } else {
            throw new Exception("property " + prop.getName() + " is of unsupported type " + propclass.toString());
        }
        setter.invoke(bean, args);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

