/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.upload;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.FileUpload;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.fulcrum.BaseService;
import org.apache.fulcrum.InitializationException;
import org.apache.fulcrum.ServiceException;
import org.apache.fulcrum.upload.UploadService;

public class TurbineUploadService
extends BaseService
implements UploadService {
    protected Object component;
    private boolean automatic;
    private int sizeThreshold;
    private int sizeMax;

    public void init() throws InitializationException {
        String repoPath = this.getConfiguration().getString("repository", ".");
        String testPath = this.getRealPath(repoPath);
        File testDir = new File(testPath);
        if (testDir.exists()) {
            repoPath = testPath;
        }
        this.getConfiguration().setProperty("repository", (Object)repoPath);
        this.getCategory().debug((Object)("Upload Service: REPOSITORY_KEY => " + repoPath));
        FileUpload upload = new FileUpload();
        this.automatic = this.getConfiguration().getBoolean("automatic", false);
        this.sizeMax = this.getConfiguration().getInt("size.max", 0x100000);
        upload.setSizeMax(this.sizeMax);
        this.sizeThreshold = this.getConfiguration().getInt("size.threshold", 10240);
        upload.setSizeThreshold(this.sizeThreshold);
        upload.setRepositoryPath(this.getConfiguration().getString("repository", "."));
        this.component = upload;
        this.setInit(true);
    }

    public Object getComponent() {
        return this.component;
    }

    public boolean getAutomatic() {
        return this.automatic;
    }

    public int getSizeMax() {
        return ((FileUpload)this.getComponent()).getSizeMax();
    }

    public int getSizeThreshold() {
        return ((FileUpload)this.getComponent()).getSizeThreshold();
    }

    public String getRepository() {
        return ((FileUpload)this.getComponent()).getRepositoryPath();
    }

    public ArrayList parseRequest(HttpServletRequest req, String path) throws ServiceException {
        try {
            return (ArrayList)((FileUpload)this.getComponent()).parseRequest(req, this.sizeThreshold, this.sizeMax, path);
        }
        catch (FileUploadException e) {
            throw new ServiceException(e);
        }
    }

    public List parseRequest(HttpServletRequest req, int sizeThreshold, int sizeMax, String path) throws ServiceException {
        try {
            return ((FileUpload)this.getComponent()).parseRequest(req, sizeThreshold, sizeMax, path);
        }
        catch (FileUploadException e) {
            throw new ServiceException(e);
        }
    }
}

