/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.security.impl;

import java.util.Iterator;
import java.util.Map;
import org.apache.fulcrum.security.TurbineSecurity;
import org.apache.fulcrum.security.entity.Group;
import org.apache.fulcrum.security.entity.Permission;
import org.apache.fulcrum.security.entity.Role;
import org.apache.fulcrum.security.util.AccessControlList;
import org.apache.fulcrum.security.util.GroupSet;
import org.apache.fulcrum.security.util.PermissionSet;
import org.apache.fulcrum.security.util.RoleSet;
import org.apache.fulcrum.security.util.TurbineSecurityException;

public class TurbineAccessControlList
implements AccessControlList {
    private Map roleSets;
    private Map permissionSets;
    private String name;

    public TurbineAccessControlList(Map roleSets, Map permissionSets) {
        this.roleSets = roleSets;
        this.permissionSets = permissionSets;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public RoleSet getRoles(Group group) {
        if (group == null) {
            return null;
        }
        return (RoleSet)this.roleSets.get(group);
    }

    public RoleSet getRoles() {
        return this.getRoles(TurbineSecurity.getGlobalGroup());
    }

    public PermissionSet getPermissions(Group group) {
        if (group == null) {
            return null;
        }
        return (PermissionSet)this.permissionSets.get(group);
    }

    public PermissionSet getPermissions() {
        return this.getPermissions(TurbineSecurity.getGlobalGroup());
    }

    public boolean hasRole(Role role, Group group) {
        RoleSet set = this.getRoles(group);
        if (set == null || role == null) {
            return false;
        }
        return set.contains(role);
    }

    public boolean hasRole(Role role, GroupSet groupset) {
        if (role == null) {
            return false;
        }
        Iterator groups = groupset.elements();
        while (groups.hasNext()) {
            Group group = (Group)groups.next();
            RoleSet roles = this.getRoles(group);
            if (roles == null || !roles.contains(role)) continue;
            return true;
        }
        return false;
    }

    public boolean hasRole(String role, String group) {
        try {
            return this.hasRole(TurbineSecurity.getRole(role), TurbineSecurity.getGroup(group));
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean hasRole(String rolename, GroupSet groupset) {
        Role role;
        try {
            role = TurbineSecurity.getRole(rolename);
        }
        catch (TurbineSecurityException e) {
            return false;
        }
        if (role == null) {
            return false;
        }
        Iterator groups = groupset.elements();
        while (groups.hasNext()) {
            Group group = (Group)groups.next();
            RoleSet roles = this.getRoles(group);
            if (roles == null || !roles.contains(role)) continue;
            return true;
        }
        return false;
    }

    public boolean hasRole(Role role) {
        return this.hasRole(role, TurbineSecurity.getGlobalGroup());
    }

    public boolean hasRole(String role) {
        try {
            return this.hasRole(TurbineSecurity.getRole(role));
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean hasPermission(Permission permission, Group group) {
        PermissionSet set = this.getPermissions(group);
        if (set == null || permission == null) {
            return false;
        }
        return set.contains(permission);
    }

    public boolean hasPermission(Permission permission, GroupSet groupset) {
        if (permission == null) {
            return false;
        }
        Iterator groups = groupset.elements();
        while (groups.hasNext()) {
            Group group = (Group)groups.next();
            PermissionSet permissions = this.getPermissions(group);
            if (permissions == null || !permissions.contains(permission)) continue;
            return true;
        }
        return false;
    }

    public boolean hasPermission(String permission, String group) {
        try {
            return this.hasPermission(TurbineSecurity.getPermission(permission), TurbineSecurity.getGroup(group));
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean hasPermission(String permission, Group group) {
        try {
            return this.hasPermission(TurbineSecurity.getPermission(permission), group);
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean hasPermission(String permissionName, GroupSet groupset) {
        Permission permission;
        try {
            permission = TurbineSecurity.getPermission(permissionName);
        }
        catch (TurbineSecurityException e) {
            return false;
        }
        if (permission == null) {
            return false;
        }
        Iterator groups = groupset.elements();
        while (groups.hasNext()) {
            Group group = (Group)groups.next();
            PermissionSet permissions = this.getPermissions(group);
            if (permissions == null || !permissions.contains(permission)) continue;
            return true;
        }
        return false;
    }

    public boolean hasPermission(Permission permission) {
        return this.hasPermission(permission, TurbineSecurity.getGlobalGroup());
    }

    public boolean hasPermission(String permission) {
        try {
            return this.hasPermission(TurbineSecurity.getPermission(permission));
        }
        catch (Exception e) {
            return false;
        }
    }

    public Group[] getAllGroups() {
        try {
            return TurbineSecurity.getAllGroups().getGroupsArray();
        }
        catch (TurbineSecurityException e) {
            return new Group[0];
        }
    }
}

