/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.security;

import java.util.Map;
import org.apache.fulcrum.Service;
import org.apache.fulcrum.security.entity.Group;
import org.apache.fulcrum.security.entity.Permission;
import org.apache.fulcrum.security.entity.Role;
import org.apache.fulcrum.security.entity.User;
import org.apache.fulcrum.security.util.AccessControlList;
import org.apache.fulcrum.security.util.DataBackendException;
import org.apache.fulcrum.security.util.EntityExistsException;
import org.apache.fulcrum.security.util.GroupSet;
import org.apache.fulcrum.security.util.PasswordMismatchException;
import org.apache.fulcrum.security.util.PermissionSet;
import org.apache.fulcrum.security.util.RoleSet;
import org.apache.fulcrum.security.util.UnknownEntityException;
import org.apache.torque.util.Criteria;

public interface SecurityService
extends Service {
    public static final String SERVICE_NAME = "SecurityService";
    public static final String USER_CLASS_KEY = "user.class";
    public static final String USER_CLASS_DEFAULT = "org.apache.fulcrum.security.impl.db.entity.TurbineUser";
    public static final String GROUP_CLASS_KEY = "group.class";
    public static final String GROUP_CLASS_DEFAULT = "org.apache.fulcrum.security.impl.db.entity.TurbineGroup";
    public static final String PERMISSION_CLASS_KEY = "permission.class";
    public static final String PERMISSION_CLASS_DEFAULT = "org.apache.fulcrum.security.impl.db.entity.TurbinePermission";
    public static final String ROLE_CLASS_KEY = "role.class";
    public static final String ROLE_CLASS_DEFAULT = "org.apache.fulcrum.security.impl.db.entity.TurbineRole";
    public static final String ACL_CLASS_KEY = "acl.class";
    public static final String ACL_CLASS_DEFAULT = "org.apache.fulcrum.security.impl.TurbineAccessControlList";
    public static final String USER_MANAGER_KEY = "user.manager";
    public static final String USER_MANAGER_DEFAULT = "org.apache.fulcrum.security.impl.db.DBUserManager";
    public static final String SECURE_PASSWORDS_KEY = "secure.passwords";
    public static final String SECURE_PASSWORDS_DEFAULT = "false";
    public static final String SECURE_PASSWORDS_ALGORITHM_KEY = "secure.passwords.algorithm";
    public static final String SECURE_PASSWORDS_ALGORITHM_DEFAULT = "SHA";

    public Class getUserClass() throws UnknownEntityException;

    public User getUserInstance() throws UnknownEntityException;

    public User getUserInstance(String var1) throws UnknownEntityException;

    public Class getGroupClass() throws UnknownEntityException;

    public Group getGroupInstance() throws UnknownEntityException;

    public Group getGroupInstance(String var1) throws UnknownEntityException;

    public Class getPermissionClass() throws UnknownEntityException;

    public Permission getPermissionInstance() throws UnknownEntityException;

    public Permission getPermissionInstance(String var1) throws UnknownEntityException;

    public Class getRoleClass() throws UnknownEntityException;

    public Role getRoleInstance() throws UnknownEntityException;

    public Role getRoleInstance(String var1) throws UnknownEntityException;

    public Class getAclClass() throws UnknownEntityException;

    public AccessControlList getAclInstance(Map var1, Map var2) throws UnknownEntityException;

    public boolean accountExists(String var1) throws DataBackendException;

    public boolean accountExists(User var1) throws DataBackendException;

    public User getAuthenticatedUser(String var1, String var2) throws DataBackendException, UnknownEntityException, PasswordMismatchException;

    public User getUser(String var1) throws DataBackendException, UnknownEntityException;

    public User[] getUsers(Criteria var1) throws DataBackendException;

    public User getAnonymousUser() throws UnknownEntityException;

    public void saveUser(User var1) throws UnknownEntityException, DataBackendException;

    public void addUser(User var1, String var2) throws DataBackendException, EntityExistsException;

    public void removeUser(User var1) throws DataBackendException, UnknownEntityException;

    public String encryptPassword(String var1);

    public void changePassword(User var1, String var2, String var3) throws PasswordMismatchException, UnknownEntityException, DataBackendException;

    public void forcePassword(User var1, String var2) throws UnknownEntityException, DataBackendException;

    public AccessControlList getACL(User var1) throws DataBackendException, UnknownEntityException;

    public PermissionSet getPermissions(Role var1) throws DataBackendException, UnknownEntityException;

    public void grant(User var1, Group var2, Role var3) throws DataBackendException, UnknownEntityException;

    public void revoke(User var1, Group var2, Role var3) throws DataBackendException, UnknownEntityException;

    public void revokeAll(User var1) throws DataBackendException, UnknownEntityException;

    public void grant(Role var1, Permission var2) throws DataBackendException, UnknownEntityException;

    public void revoke(Role var1, Permission var2) throws DataBackendException, UnknownEntityException;

    public void revokeAll(Role var1) throws DataBackendException, UnknownEntityException;

    public Group getGlobalGroup();

    public Group getNewGroup(String var1);

    public Role getNewRole(String var1);

    public Permission getNewPermission(String var1);

    public Group getGroup(String var1) throws DataBackendException, UnknownEntityException;

    public Role getRole(String var1) throws DataBackendException, UnknownEntityException;

    public Permission getPermission(String var1) throws DataBackendException, UnknownEntityException;

    public GroupSet getGroups(Criteria var1) throws DataBackendException;

    public RoleSet getRoles(Criteria var1) throws DataBackendException;

    public PermissionSet getPermissions(Criteria var1) throws DataBackendException;

    public GroupSet getAllGroups() throws DataBackendException;

    public RoleSet getAllRoles() throws DataBackendException;

    public PermissionSet getAllPermissions() throws DataBackendException;

    public void saveGroup(Group var1) throws DataBackendException, UnknownEntityException;

    public void saveRole(Role var1) throws DataBackendException, UnknownEntityException;

    public void savePermission(Permission var1) throws DataBackendException, UnknownEntityException;

    public Group addGroup(Group var1) throws DataBackendException, EntityExistsException;

    public Role addRole(Role var1) throws DataBackendException, EntityExistsException;

    public Permission addPermission(Permission var1) throws DataBackendException, EntityExistsException;

    public void removeGroup(Group var1) throws DataBackendException, UnknownEntityException;

    public void removeRole(Role var1) throws DataBackendException, UnknownEntityException;

    public void removePermission(Permission var1) throws DataBackendException, UnknownEntityException;

    public void renameGroup(Group var1, String var2) throws DataBackendException, UnknownEntityException;

    public void renameRole(Role var1, String var2) throws DataBackendException, UnknownEntityException;

    public void renamePermission(Permission var1, String var2) throws DataBackendException, UnknownEntityException;

    static {
        SERVICE_NAME = SERVICE_NAME;
        USER_CLASS_KEY = USER_CLASS_KEY;
        USER_CLASS_DEFAULT = USER_CLASS_DEFAULT;
        GROUP_CLASS_KEY = GROUP_CLASS_KEY;
        GROUP_CLASS_DEFAULT = GROUP_CLASS_DEFAULT;
        PERMISSION_CLASS_KEY = PERMISSION_CLASS_KEY;
        PERMISSION_CLASS_DEFAULT = PERMISSION_CLASS_DEFAULT;
        ROLE_CLASS_KEY = ROLE_CLASS_KEY;
        ROLE_CLASS_DEFAULT = ROLE_CLASS_DEFAULT;
        ACL_CLASS_KEY = ACL_CLASS_KEY;
        ACL_CLASS_DEFAULT = ACL_CLASS_DEFAULT;
        USER_MANAGER_KEY = USER_MANAGER_KEY;
        USER_MANAGER_DEFAULT = USER_MANAGER_DEFAULT;
        SECURE_PASSWORDS_KEY = SECURE_PASSWORDS_KEY;
        SECURE_PASSWORDS_DEFAULT = SECURE_PASSWORDS_DEFAULT;
        SECURE_PASSWORDS_ALGORITHM_KEY = SECURE_PASSWORDS_ALGORITHM_KEY;
        SECURE_PASSWORDS_ALGORITHM_DEFAULT = SECURE_PASSWORDS_ALGORITHM_DEFAULT;
    }
}

