/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.schedule;

import java.util.Iterator;
import java.util.List;
import org.apache.fulcrum.BaseService;
import org.apache.fulcrum.InitializationException;
import org.apache.fulcrum.schedule.JobEntry;
import org.apache.fulcrum.schedule.JobEntryPeer;
import org.apache.fulcrum.schedule.JobQueue;
import org.apache.fulcrum.schedule.ScheduleService;
import org.apache.fulcrum.schedule.WorkerThread;
import org.apache.torque.om.NumberKey;
import org.apache.torque.om.ObjectKey;
import org.apache.torque.util.Criteria;

public class TurbineSchedulerService
extends BaseService
implements ScheduleService {
    protected JobQueue scheduleQueue = null;
    protected MainLoop mainLoop = null;
    protected Thread thread = null;

    public void init() throws InitializationException {
        try {
            this.scheduleQueue = new JobQueue();
            this.mainLoop = new MainLoop();
            List jobs = JobEntryPeer.doSelect(new Criteria());
            if (jobs != null && jobs.size() > 0) {
                Iterator it = jobs.iterator();
                while (it.hasNext()) {
                    ((JobEntry)it.next()).calcRunTime();
                }
                this.scheduleQueue.batchLoad(jobs);
                this.restart();
            }
            this.setInit(true);
        }
        catch (Exception e) {
            throw new InitializationException("Failed to start the scheduler service: ", e);
        }
    }

    public void shutdown() {
        if (this.getThread() != null) {
            this.getThread().interrupt();
        }
    }

    public JobEntry getJob(int oid) throws Exception {
        JobEntry je = JobEntryPeer.retrieveByPK((ObjectKey)new NumberKey(oid));
        return this.scheduleQueue.getJob(je);
    }

    public void addJob(JobEntry je) throws Exception {
        try {
            je.calcRunTime();
            je.save();
        }
        catch (Exception e) {
            this.getCategory().error((Object)("Problem saving new Scheduled Job: " + e));
        }
        this.scheduleQueue.add(je);
        this.restart();
    }

    public void removeJob(JobEntry je) throws Exception {
        try {
            Criteria c = new Criteria().add(JobEntryPeer.JOB_ID, (Object)je.getPrimaryKey());
            JobEntryPeer.doDelete(c);
        }
        catch (Exception ouch) {
            this.getCategory().error((Object)("Problem removing Scheduled Job: " + ouch));
        }
        this.scheduleQueue.remove(je);
        this.restart();
    }

    public void updateJob(JobEntry je) throws Exception {
        try {
            je.calcRunTime();
            je.save();
        }
        catch (Exception e) {
            this.getCategory().error((Object)("Problem updating Scheduled Job: " + e));
        }
        this.scheduleQueue.modify(je);
        this.restart();
    }

    public List listJobs() {
        return this.scheduleQueue.list();
    }

    public synchronized Thread getThread() {
        return this.thread;
    }

    private synchronized void clearThread() {
        this.thread = null;
    }

    public synchronized void restart() {
        if (this.thread == null) {
            this.thread = new Thread((Runnable)this.mainLoop, "SchedulerService");
            this.thread.setDaemon(true);
            this.thread.start();
        } else {
            this.notify();
        }
    }

    private synchronized JobEntry nextJob() throws Exception {
        try {
            while (!Thread.interrupted()) {
                JobEntry je = this.scheduleQueue.getNext();
                if (je == null) {
                    this.wait();
                    continue;
                }
                long now = System.currentTimeMillis();
                long when = je.getNextRuntime();
                if (when > now) {
                    this.wait(when - now);
                    continue;
                }
                this.scheduleQueue.updateQueue(je);
                return je;
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return null;
    }

    protected class MainLoop
    implements Runnable {
        protected MainLoop() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            try {
                try {
                    JobEntry je;
                    while ((je = TurbineSchedulerService.this.nextJob()) != null) {
                        WorkerThread wt = new WorkerThread(je);
                        Thread helper = new Thread(wt);
                        helper.start();
                    }
                    Object var5_5 = null;
                }
                catch (Exception e) {
                    TurbineSchedulerService.this.getCategory().error((Object)("Error running a Scheduled Job: " + e));
                    Object var5_6 = null;
                    TurbineSchedulerService.this.clearThread();
                    return;
                }
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                TurbineSchedulerService.this.clearThread();
                throw throwable;
            }
            TurbineSchedulerService.this.clearThread();
        }
    }
}

